/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.identifier;

import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.identifier.DBIdentifierUtilImpl;
import org.apache.openjpa.jdbc.identifier.DefaultIdentifierConfiguration;
import org.apache.openjpa.lib.identifier.IdentifierConfiguration;
import org.apache.openjpa.lib.identifier.IdentifierRule;
import org.apache.openjpa.lib.identifier.IdentifierUtil;

public class Normalizer {
    private static IdentifierUtil normalizer = new DBIdentifierUtilImpl(new DefaultIdentifierConfiguration());
    private static IdentifierRule defaultRule = normalizer.getIdentifierConfiguration().getDefaultIdentifierRule();

    public static IdentifierConfiguration getNamingConfiguration() {
        return normalizer.getIdentifierConfiguration();
    }

    public static String normalizeMulti(String name) {
        if (StringUtils.isEmpty(name)) {
            return name;
        }
        String[] names = normalizer.splitName(defaultRule, name);
        return normalizer.joinNames(defaultRule, names);
    }

    public static String normalizeString(String name) {
        if (StringUtils.isEmpty(name)) {
            return name;
        }
        if (!normalizer.isDelimited(defaultRule, name)) {
            return normalizer.delimit(defaultRule, name);
        }
        return name;
    }

    public static boolean isDelimited(String name) {
        if (StringUtils.isEmpty(name)) {
            return false;
        }
        return normalizer.isDelimited(defaultRule, name);
    }

    public static boolean fullNamesEqual(String name1, String name2) {
        String[] names2;
        if (StringUtils.isEmpty(name1) && StringUtils.isEmpty(name2)) {
            return true;
        }
        String[] names1 = normalizer.splitName(defaultRule, name1);
        if (names1.length != (names2 = normalizer.splitName(defaultRule, name2)).length) {
            return false;
        }
        for (int i = 0; i < names1.length; ++i) {
            if (!(normalizer.isDelimited(defaultRule, names1[i]) ? !StringUtils.equals(names1[i], names2[i]) : !StringUtils.equalsIgnoreCase(names1[i], names2[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean namesEqual(String name1, String name2) {
        if (StringUtils.isEmpty(name1) && StringUtils.isEmpty(name2)) {
            return true;
        }
        return !(normalizer.isDelimited(defaultRule, name1) ? !StringUtils.equals(name1, name2) : !StringUtils.equalsIgnoreCase(name1, name2));
    }

    public static String normalizeUpper(String name) {
        String nName = Normalizer.normalizeString(name);
        if (!Normalizer.isDelimited(nName)) {
            nName = name.toUpperCase();
        }
        return nName;
    }

    public static String[] splitName(String name) {
        return normalizer.splitName(defaultRule, name);
    }

    public static String[] splitName(String name, String delim) {
        return normalizer.splitName(defaultRule, name, delim);
    }

    public static String joinNames(String[] names) {
        return normalizer.joinNames(defaultRule, names);
    }

    public static String joinNames(String[] names, String delimiter) {
        return normalizer.joinNames(defaultRule, names, delimiter);
    }

    public static String joinNames(String name1, String name2) {
        return Normalizer.joinNames(new String[]{name1, name2});
    }

    public static String truncate(String name, int length) {
        return normalizer.truncateName(defaultRule, name, length);
    }

    public static String convert(IdentifierConfiguration config, String rule, String name) {
        return normalizer.convert(config, rule, name);
    }

    public static String combine(String name1, String name2) {
        return normalizer.combineNames(defaultRule, name1, name2);
    }

    public static String combine(String ... names) {
        return normalizer.combineNames(defaultRule, names);
    }

    public static String append(String name1, String name2) {
        return normalizer.appendNames(defaultRule, name1, name2);
    }

    public static String removeHungarianNotation(String name) {
        return normalizer.removeHungarianNotation(defaultRule, name);
    }

    public static String removeDelimiters(String name) {
        return normalizer.removeDelimiters(defaultRule, name);
    }

    public static String delimit(String name, boolean force) {
        return normalizer.delimit(defaultRule, name, force);
    }

    public static boolean canSplit(String name) {
        return normalizer.canSplit(defaultRule, name);
    }

    public static boolean canSplit(String name, String delim) {
        return normalizer.canSplit(defaultRule, name, delim);
    }
}

