/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.datacache.DataCachePCDataImpl;
import org.apache.openjpa.enhance.PCDataGenerator;
import org.apache.openjpa.kernel.AbstractPCData;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.tree.ClassNode;
import org.apache.xbean.asm9.tree.FieldInsnNode;
import org.apache.xbean.asm9.tree.FieldNode;
import org.apache.xbean.asm9.tree.InsnList;
import org.apache.xbean.asm9.tree.InsnNode;
import org.apache.xbean.asm9.tree.JumpInsnNode;
import org.apache.xbean.asm9.tree.LabelNode;
import org.apache.xbean.asm9.tree.MethodInsnNode;
import org.apache.xbean.asm9.tree.MethodNode;
import org.apache.xbean.asm9.tree.TypeInsnNode;
import org.apache.xbean.asm9.tree.VarInsnNode;

public class DataCachePCDataGenerator
extends PCDataGenerator {
    public static final String POSTFIX = "datacache";
    private static final Set _synchs = new HashSet<String>(Arrays.asList("getData", "setData", "clearData", "getImplData", "setImplData", "setIntermediate", "getIntermediate", "isLoaded", "setLoaded", "setVersion", "getVersion", "store"));

    public DataCachePCDataGenerator(OpenJPAConfiguration conf) {
        super(conf);
    }

    protected String getUniqueName(Class type) {
        return super.getUniqueName(type) + POSTFIX;
    }

    @Override
    protected void finish(PCDataGenerator.DynamicPCData data, ClassMetaData meta) {
        int timeout = meta.getDataCacheTimeout();
        if (timeout > 0) {
            ((Timed)((Object)data)).setTimeout((long)timeout + System.currentTimeMillis());
        } else {
            ((Timed)((Object)data)).setTimeout(-1L);
        }
    }

    @Override
    protected void decorate(ClassNodeTracker cnt, ClassMetaData meta) {
        this.enhanceToData(cnt);
        this.enhanceToNestedData(cnt);
        this.replaceNewEmbeddedPCData(cnt);
        this.addSynchronization(cnt);
        this.addTimeout(cnt);
    }

    private void enhanceToData(ClassNodeTracker cnt) {
        ClassNode classNode = cnt.getClassNode();
        MethodNode meth = new MethodNode(1, "toData", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, Type.getType(FieldMetaData.class), AsmHelper.TYPE_OBJECT, Type.getType(StoreContext.class)), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(182, Type.getInternalName(FieldMetaData.class), "isLRS", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0])));
        LabelNode lblEndIfEq = new LabelNode();
        instructions.add(new JumpInsnNode(153, lblEndIfEq));
        instructions.add(new FieldInsnNode(178, Type.getInternalName(AbstractPCData.class), "NULL", AsmHelper.TYPE_OBJECT.getDescriptor()));
        instructions.add(new InsnNode(176));
        instructions.add(lblEndIfEq);
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new VarInsnNode(25, 2));
        instructions.add(new VarInsnNode(25, 3));
        instructions.add(new MethodInsnNode(183, Type.getInternalName(AbstractPCData.class), "toData", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, Type.getType(FieldMetaData.class), AsmHelper.TYPE_OBJECT, Type.getType(StoreContext.class))));
        instructions.add(new InsnNode(176));
    }

    private void enhanceToNestedData(ClassNodeTracker cnt) {
        ClassNode classNode = cnt.getClassNode();
        MethodNode meth = new MethodNode(1, "toNestedData", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, Type.getType(ValueMetaData.class), AsmHelper.TYPE_OBJECT, Type.getType(StoreContext.class)), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        instructions.add(new VarInsnNode(25, 1));
        LabelNode lblEndIfNN = new LabelNode();
        instructions.add(new JumpInsnNode(199, lblEndIfNN));
        instructions.add(new InsnNode(1));
        instructions.add(new InsnNode(176));
        instructions.add(lblEndIfNN);
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(185, Type.getInternalName(ValueMetaData.class), "getDeclaredTypeCode", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0])));
        int varPos = AsmHelper.getLocalVarPos(meth);
        instructions.add(new VarInsnNode(54, varPos));
        LabelNode lblEndIf = new LabelNode();
        instructions.add(new VarInsnNode(21, varPos));
        instructions.add(AsmHelper.getLoadConstantInsn(12));
        instructions.add(new JumpInsnNode(159, lblEndIf));
        instructions.add(new VarInsnNode(21, varPos));
        instructions.add(AsmHelper.getLoadConstantInsn(13));
        instructions.add(new JumpInsnNode(159, lblEndIf));
        instructions.add(new VarInsnNode(21, varPos));
        instructions.add(AsmHelper.getLoadConstantInsn(11));
        instructions.add(new JumpInsnNode(159, lblEndIf));
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new VarInsnNode(25, 2));
        instructions.add(new VarInsnNode(25, 3));
        instructions.add(new MethodInsnNode(183, Type.getInternalName(AbstractPCData.class), "toNestedData", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, Type.getType(ValueMetaData.class), AsmHelper.TYPE_OBJECT, Type.getType(StoreContext.class))));
        instructions.add(new InsnNode(176));
        instructions.add(lblEndIf);
        instructions.add(new FieldInsnNode(178, Type.getInternalName(AbstractPCData.class), "NULL", AsmHelper.TYPE_OBJECT.getDescriptor()));
        instructions.add(new InsnNode(176));
    }

    private void replaceNewEmbeddedPCData(ClassNodeTracker cnt) {
        ClassNode classNode = cnt.getClassNode();
        MethodNode meth = new MethodNode(1, "newEmbeddedPCData", Type.getMethodDescriptor(Type.getType(AbstractPCData.class), Type.getType(OpenJPAStateManager.class)), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        instructions.add(new TypeInsnNode(187, Type.getInternalName(DataCachePCDataImpl.class)));
        instructions.add(new InsnNode(89));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getId", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getMetaData", Type.getMethodDescriptor(Type.getType(ClassMetaData.class), new Type[0])));
        instructions.add(new MethodInsnNode(183, Type.getInternalName(DataCachePCDataImpl.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT, Type.getType(ClassMetaData.class))));
        instructions.add(new InsnNode(176));
    }

    private void addTimeout(ClassNodeTracker cnt) {
        cnt.declareInterface(DataCachePCData.class);
        cnt.declareInterface(Timed.class);
        FieldNode field = this.addBeanField(cnt, "timeout", Long.TYPE);
        ClassNode classNode = cnt.getClassNode();
        MethodNode meth = new MethodNode(1, "isTimedOut", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, field.name, field.desc));
        instructions.add(AsmHelper.getLoadConstantInsn(-1L));
        instructions.add(new InsnNode(148));
        LabelNode lblEndIf = new LabelNode();
        instructions.add(new JumpInsnNode(153, lblEndIf));
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, field.name, field.desc));
        instructions.add(new MethodInsnNode(184, Type.getInternalName(System.class), "currentTimeMillis", Type.getMethodDescriptor(Type.LONG_TYPE, new Type[0])));
        instructions.add(new InsnNode(148));
        instructions.add(new JumpInsnNode(156, lblEndIf));
        instructions.add(new InsnNode(4));
        instructions.add(new InsnNode(172));
        instructions.add(lblEndIf);
        instructions.add(new InsnNode(3));
        instructions.add(new InsnNode(172));
    }

    private void addSynchronization(ClassNodeTracker cnt) {
        ClassNode classNode = cnt.getClassNode();
        for (MethodNode m : classNode.methods) {
            if ((m.access & 1) <= 0 || !_synchs.contains(m.name)) continue;
            m.access |= 0x20;
        }
        MethodNode meth = new MethodNode(33, "isLoaded", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.INT_TYPE), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(21, 1));
        instructions.add(new MethodInsnNode(183, Type.getInternalName(AbstractPCData.class), "isLoaded", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.INT_TYPE)));
        instructions.add(new InsnNode(172));
    }

    public static interface Timed {
        public void setTimeout(long var1);
    }
}

