/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDeviceAddressBinding is the corresponding interface of BACnetConstructedDataDeviceAddressBinding
type BACnetConstructedDataDeviceAddressBinding interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDeviceAddressBinding returns DeviceAddressBinding (property field)
	GetDeviceAddressBinding() []BACnetAddressBinding
	// IsBACnetConstructedDataDeviceAddressBinding is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDeviceAddressBinding()
	// CreateBuilder creates a BACnetConstructedDataDeviceAddressBindingBuilder
	CreateBACnetConstructedDataDeviceAddressBindingBuilder() BACnetConstructedDataDeviceAddressBindingBuilder
}

// _BACnetConstructedDataDeviceAddressBinding is the data-structure of this message
type _BACnetConstructedDataDeviceAddressBinding struct {
	BACnetConstructedDataContract
	DeviceAddressBinding []BACnetAddressBinding
}

var _ BACnetConstructedDataDeviceAddressBinding = (*_BACnetConstructedDataDeviceAddressBinding)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDeviceAddressBinding)(nil)

// NewBACnetConstructedDataDeviceAddressBinding factory function for _BACnetConstructedDataDeviceAddressBinding
func NewBACnetConstructedDataDeviceAddressBinding(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, deviceAddressBinding []BACnetAddressBinding, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDeviceAddressBinding {
	_result := &_BACnetConstructedDataDeviceAddressBinding{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DeviceAddressBinding:          deviceAddressBinding,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDeviceAddressBindingBuilder is a builder for BACnetConstructedDataDeviceAddressBinding
type BACnetConstructedDataDeviceAddressBindingBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(deviceAddressBinding []BACnetAddressBinding) BACnetConstructedDataDeviceAddressBindingBuilder
	// WithDeviceAddressBinding adds DeviceAddressBinding (property field)
	WithDeviceAddressBinding(...BACnetAddressBinding) BACnetConstructedDataDeviceAddressBindingBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDeviceAddressBinding or returns an error if something is wrong
	Build() (BACnetConstructedDataDeviceAddressBinding, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDeviceAddressBinding
}

// NewBACnetConstructedDataDeviceAddressBindingBuilder() creates a BACnetConstructedDataDeviceAddressBindingBuilder
func NewBACnetConstructedDataDeviceAddressBindingBuilder() BACnetConstructedDataDeviceAddressBindingBuilder {
	return &_BACnetConstructedDataDeviceAddressBindingBuilder{_BACnetConstructedDataDeviceAddressBinding: new(_BACnetConstructedDataDeviceAddressBinding)}
}

type _BACnetConstructedDataDeviceAddressBindingBuilder struct {
	*_BACnetConstructedDataDeviceAddressBinding

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDeviceAddressBindingBuilder) = (*_BACnetConstructedDataDeviceAddressBindingBuilder)(nil)

func (b *_BACnetConstructedDataDeviceAddressBindingBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDeviceAddressBinding
}

func (b *_BACnetConstructedDataDeviceAddressBindingBuilder) WithMandatoryFields(deviceAddressBinding []BACnetAddressBinding) BACnetConstructedDataDeviceAddressBindingBuilder {
	return b.WithDeviceAddressBinding(deviceAddressBinding...)
}

func (b *_BACnetConstructedDataDeviceAddressBindingBuilder) WithDeviceAddressBinding(deviceAddressBinding ...BACnetAddressBinding) BACnetConstructedDataDeviceAddressBindingBuilder {
	b.DeviceAddressBinding = deviceAddressBinding
	return b
}

func (b *_BACnetConstructedDataDeviceAddressBindingBuilder) Build() (BACnetConstructedDataDeviceAddressBinding, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDeviceAddressBinding.deepCopy(), nil
}

func (b *_BACnetConstructedDataDeviceAddressBindingBuilder) MustBuild() BACnetConstructedDataDeviceAddressBinding {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDeviceAddressBindingBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDeviceAddressBindingBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDeviceAddressBindingBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDeviceAddressBindingBuilder().(*_BACnetConstructedDataDeviceAddressBindingBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDeviceAddressBindingBuilder creates a BACnetConstructedDataDeviceAddressBindingBuilder
func (b *_BACnetConstructedDataDeviceAddressBinding) CreateBACnetConstructedDataDeviceAddressBindingBuilder() BACnetConstructedDataDeviceAddressBindingBuilder {
	if b == nil {
		return NewBACnetConstructedDataDeviceAddressBindingBuilder()
	}
	return &_BACnetConstructedDataDeviceAddressBindingBuilder{_BACnetConstructedDataDeviceAddressBinding: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDeviceAddressBinding) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDeviceAddressBinding) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DEVICE_ADDRESS_BINDING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDeviceAddressBinding) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDeviceAddressBinding) GetDeviceAddressBinding() []BACnetAddressBinding {
	return m.DeviceAddressBinding
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDeviceAddressBinding(structType any) BACnetConstructedDataDeviceAddressBinding {
	if casted, ok := structType.(BACnetConstructedDataDeviceAddressBinding); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDeviceAddressBinding); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDeviceAddressBinding) GetTypeName() string {
	return "BACnetConstructedDataDeviceAddressBinding"
}

func (m *_BACnetConstructedDataDeviceAddressBinding) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.DeviceAddressBinding) > 0 {
		for _, element := range m.DeviceAddressBinding {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataDeviceAddressBinding) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDeviceAddressBinding) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDeviceAddressBinding BACnetConstructedDataDeviceAddressBinding, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDeviceAddressBinding"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDeviceAddressBinding")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	deviceAddressBinding, err := ReadTerminatedArrayField[BACnetAddressBinding](ctx, "deviceAddressBinding", ReadComplex[BACnetAddressBinding](BACnetAddressBindingParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceAddressBinding' field"))
	}
	m.DeviceAddressBinding = deviceAddressBinding

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDeviceAddressBinding"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDeviceAddressBinding")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDeviceAddressBinding) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDeviceAddressBinding) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDeviceAddressBinding"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDeviceAddressBinding")
		}

		if err := WriteComplexTypeArrayField(ctx, "deviceAddressBinding", m.GetDeviceAddressBinding(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'deviceAddressBinding' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDeviceAddressBinding"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDeviceAddressBinding")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDeviceAddressBinding) IsBACnetConstructedDataDeviceAddressBinding() {}

func (m *_BACnetConstructedDataDeviceAddressBinding) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDeviceAddressBinding) deepCopy() *_BACnetConstructedDataDeviceAddressBinding {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDeviceAddressBindingCopy := &_BACnetConstructedDataDeviceAddressBinding{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetAddressBinding, BACnetAddressBinding](m.DeviceAddressBinding),
	}
	_BACnetConstructedDataDeviceAddressBindingCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDeviceAddressBindingCopy
}

func (m *_BACnetConstructedDataDeviceAddressBinding) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
