/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataMemberOf is the corresponding interface of BACnetConstructedDataMemberOf
type BACnetConstructedDataMemberOf interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetZones returns Zones (property field)
	GetZones() []BACnetDeviceObjectReference
	// IsBACnetConstructedDataMemberOf is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataMemberOf()
	// CreateBuilder creates a BACnetConstructedDataMemberOfBuilder
	CreateBACnetConstructedDataMemberOfBuilder() BACnetConstructedDataMemberOfBuilder
}

// _BACnetConstructedDataMemberOf is the data-structure of this message
type _BACnetConstructedDataMemberOf struct {
	BACnetConstructedDataContract
	Zones []BACnetDeviceObjectReference
}

var _ BACnetConstructedDataMemberOf = (*_BACnetConstructedDataMemberOf)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataMemberOf)(nil)

// NewBACnetConstructedDataMemberOf factory function for _BACnetConstructedDataMemberOf
func NewBACnetConstructedDataMemberOf(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, zones []BACnetDeviceObjectReference, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataMemberOf {
	_result := &_BACnetConstructedDataMemberOf{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Zones:                         zones,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataMemberOfBuilder is a builder for BACnetConstructedDataMemberOf
type BACnetConstructedDataMemberOfBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zones []BACnetDeviceObjectReference) BACnetConstructedDataMemberOfBuilder
	// WithZones adds Zones (property field)
	WithZones(...BACnetDeviceObjectReference) BACnetConstructedDataMemberOfBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataMemberOf or returns an error if something is wrong
	Build() (BACnetConstructedDataMemberOf, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataMemberOf
}

// NewBACnetConstructedDataMemberOfBuilder() creates a BACnetConstructedDataMemberOfBuilder
func NewBACnetConstructedDataMemberOfBuilder() BACnetConstructedDataMemberOfBuilder {
	return &_BACnetConstructedDataMemberOfBuilder{_BACnetConstructedDataMemberOf: new(_BACnetConstructedDataMemberOf)}
}

type _BACnetConstructedDataMemberOfBuilder struct {
	*_BACnetConstructedDataMemberOf

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataMemberOfBuilder) = (*_BACnetConstructedDataMemberOfBuilder)(nil)

func (b *_BACnetConstructedDataMemberOfBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataMemberOf
}

func (b *_BACnetConstructedDataMemberOfBuilder) WithMandatoryFields(zones []BACnetDeviceObjectReference) BACnetConstructedDataMemberOfBuilder {
	return b.WithZones(zones...)
}

func (b *_BACnetConstructedDataMemberOfBuilder) WithZones(zones ...BACnetDeviceObjectReference) BACnetConstructedDataMemberOfBuilder {
	b.Zones = zones
	return b
}

func (b *_BACnetConstructedDataMemberOfBuilder) Build() (BACnetConstructedDataMemberOf, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataMemberOf.deepCopy(), nil
}

func (b *_BACnetConstructedDataMemberOfBuilder) MustBuild() BACnetConstructedDataMemberOf {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataMemberOfBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataMemberOfBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataMemberOfBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataMemberOfBuilder().(*_BACnetConstructedDataMemberOfBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataMemberOfBuilder creates a BACnetConstructedDataMemberOfBuilder
func (b *_BACnetConstructedDataMemberOf) CreateBACnetConstructedDataMemberOfBuilder() BACnetConstructedDataMemberOfBuilder {
	if b == nil {
		return NewBACnetConstructedDataMemberOfBuilder()
	}
	return &_BACnetConstructedDataMemberOfBuilder{_BACnetConstructedDataMemberOf: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataMemberOf) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataMemberOf) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MEMBER_OF
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataMemberOf) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataMemberOf) GetZones() []BACnetDeviceObjectReference {
	return m.Zones
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataMemberOf(structType any) BACnetConstructedDataMemberOf {
	if casted, ok := structType.(BACnetConstructedDataMemberOf); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataMemberOf); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataMemberOf) GetTypeName() string {
	return "BACnetConstructedDataMemberOf"
}

func (m *_BACnetConstructedDataMemberOf) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.Zones) > 0 {
		for _, element := range m.Zones {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataMemberOf) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataMemberOf) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataMemberOf BACnetConstructedDataMemberOf, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataMemberOf"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataMemberOf")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zones, err := ReadTerminatedArrayField[BACnetDeviceObjectReference](ctx, "zones", ReadComplex[BACnetDeviceObjectReference](BACnetDeviceObjectReferenceParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zones' field"))
	}
	m.Zones = zones

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataMemberOf"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataMemberOf")
	}

	return m, nil
}

func (m *_BACnetConstructedDataMemberOf) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataMemberOf) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataMemberOf"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataMemberOf")
		}

		if err := WriteComplexTypeArrayField(ctx, "zones", m.GetZones(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'zones' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataMemberOf"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataMemberOf")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataMemberOf) IsBACnetConstructedDataMemberOf() {}

func (m *_BACnetConstructedDataMemberOf) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataMemberOf) deepCopy() *_BACnetConstructedDataMemberOf {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataMemberOfCopy := &_BACnetConstructedDataMemberOf{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetDeviceObjectReference, BACnetDeviceObjectReference](m.Zones),
	}
	_BACnetConstructedDataMemberOfCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataMemberOfCopy
}

func (m *_BACnetConstructedDataMemberOf) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
