/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SALDataMetering is the corresponding interface of SALDataMetering
type SALDataMetering interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SALData
	// GetMeteringData returns MeteringData (property field)
	GetMeteringData() MeteringData
	// IsSALDataMetering is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSALDataMetering()
	// CreateBuilder creates a SALDataMeteringBuilder
	CreateSALDataMeteringBuilder() SALDataMeteringBuilder
}

// _SALDataMetering is the data-structure of this message
type _SALDataMetering struct {
	SALDataContract
	MeteringData MeteringData
}

var _ SALDataMetering = (*_SALDataMetering)(nil)
var _ SALDataRequirements = (*_SALDataMetering)(nil)

// NewSALDataMetering factory function for _SALDataMetering
func NewSALDataMetering(salData SALData, meteringData MeteringData) *_SALDataMetering {
	if meteringData == nil {
		panic("meteringData of type MeteringData for SALDataMetering must not be nil")
	}
	_result := &_SALDataMetering{
		SALDataContract: NewSALData(salData),
		MeteringData:    meteringData,
	}
	_result.SALDataContract.(*_SALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SALDataMeteringBuilder is a builder for SALDataMetering
type SALDataMeteringBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(meteringData MeteringData) SALDataMeteringBuilder
	// WithMeteringData adds MeteringData (property field)
	WithMeteringData(MeteringData) SALDataMeteringBuilder
	// WithMeteringDataBuilder adds MeteringData (property field) which is build by the builder
	WithMeteringDataBuilder(func(MeteringDataBuilder) MeteringDataBuilder) SALDataMeteringBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SALDataBuilder
	// Build builds the SALDataMetering or returns an error if something is wrong
	Build() (SALDataMetering, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SALDataMetering
}

// NewSALDataMeteringBuilder() creates a SALDataMeteringBuilder
func NewSALDataMeteringBuilder() SALDataMeteringBuilder {
	return &_SALDataMeteringBuilder{_SALDataMetering: new(_SALDataMetering)}
}

type _SALDataMeteringBuilder struct {
	*_SALDataMetering

	parentBuilder *_SALDataBuilder

	collectedErr []error
}

var _ (SALDataMeteringBuilder) = (*_SALDataMeteringBuilder)(nil)

func (b *_SALDataMeteringBuilder) setParent(contract SALDataContract) {
	b.SALDataContract = contract
	contract.(*_SALData)._SubType = b._SALDataMetering
}

func (b *_SALDataMeteringBuilder) WithMandatoryFields(meteringData MeteringData) SALDataMeteringBuilder {
	return b.WithMeteringData(meteringData)
}

func (b *_SALDataMeteringBuilder) WithMeteringData(meteringData MeteringData) SALDataMeteringBuilder {
	b.MeteringData = meteringData
	return b
}

func (b *_SALDataMeteringBuilder) WithMeteringDataBuilder(builderSupplier func(MeteringDataBuilder) MeteringDataBuilder) SALDataMeteringBuilder {
	builder := builderSupplier(b.MeteringData.CreateMeteringDataBuilder())
	var err error
	b.MeteringData, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "MeteringDataBuilder failed"))
	}
	return b
}

func (b *_SALDataMeteringBuilder) Build() (SALDataMetering, error) {
	if b.MeteringData == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'meteringData' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SALDataMetering.deepCopy(), nil
}

func (b *_SALDataMeteringBuilder) MustBuild() SALDataMetering {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SALDataMeteringBuilder) Done() SALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSALDataBuilder().(*_SALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SALDataMeteringBuilder) buildForSALData() (SALData, error) {
	return b.Build()
}

func (b *_SALDataMeteringBuilder) DeepCopy() any {
	_copy := b.CreateSALDataMeteringBuilder().(*_SALDataMeteringBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSALDataMeteringBuilder creates a SALDataMeteringBuilder
func (b *_SALDataMetering) CreateSALDataMeteringBuilder() SALDataMeteringBuilder {
	if b == nil {
		return NewSALDataMeteringBuilder()
	}
	return &_SALDataMeteringBuilder{_SALDataMetering: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SALDataMetering) GetApplicationId() ApplicationId {
	return ApplicationId_METERING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SALDataMetering) GetParent() SALDataContract {
	return m.SALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SALDataMetering) GetMeteringData() MeteringData {
	return m.MeteringData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSALDataMetering(structType any) SALDataMetering {
	if casted, ok := structType.(SALDataMetering); ok {
		return casted
	}
	if casted, ok := structType.(*SALDataMetering); ok {
		return *casted
	}
	return nil
}

func (m *_SALDataMetering) GetTypeName() string {
	return "SALDataMetering"
}

func (m *_SALDataMetering) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SALDataContract.(*_SALData).getLengthInBits(ctx))

	// Simple field (meteringData)
	lengthInBits += m.MeteringData.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SALDataMetering) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SALDataMetering) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SALData, applicationId ApplicationId) (__sALDataMetering SALDataMetering, err error) {
	m.SALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SALDataMetering"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SALDataMetering")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	meteringData, err := ReadSimpleField[MeteringData](ctx, "meteringData", ReadComplex[MeteringData](MeteringDataParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'meteringData' field"))
	}
	m.MeteringData = meteringData

	if closeErr := readBuffer.CloseContext("SALDataMetering"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SALDataMetering")
	}

	return m, nil
}

func (m *_SALDataMetering) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SALDataMetering) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SALDataMetering"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SALDataMetering")
		}

		if err := WriteSimpleField[MeteringData](ctx, "meteringData", m.GetMeteringData(), WriteComplex[MeteringData](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'meteringData' field")
		}

		if popErr := writeBuffer.PopContext("SALDataMetering"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SALDataMetering")
		}
		return nil
	}
	return m.SALDataContract.(*_SALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SALDataMetering) IsSALDataMetering() {}

func (m *_SALDataMetering) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SALDataMetering) deepCopy() *_SALDataMetering {
	if m == nil {
		return nil
	}
	_SALDataMeteringCopy := &_SALDataMetering{
		m.SALDataContract.(*_SALData).deepCopy(),
		utils.DeepCopy[MeteringData](m.MeteringData),
	}
	_SALDataMeteringCopy.SALDataContract.(*_SALData)._SubType = m
	return _SALDataMeteringCopy
}

func (m *_SALDataMetering) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
