/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtIndividualAddressSerialNumberRead is the corresponding interface of ApduDataExtIndividualAddressSerialNumberRead
type ApduDataExtIndividualAddressSerialNumberRead interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtIndividualAddressSerialNumberRead is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtIndividualAddressSerialNumberRead()
	// CreateBuilder creates a ApduDataExtIndividualAddressSerialNumberReadBuilder
	CreateApduDataExtIndividualAddressSerialNumberReadBuilder() ApduDataExtIndividualAddressSerialNumberReadBuilder
}

// _ApduDataExtIndividualAddressSerialNumberRead is the data-structure of this message
type _ApduDataExtIndividualAddressSerialNumberRead struct {
	ApduDataExtContract
}

var _ ApduDataExtIndividualAddressSerialNumberRead = (*_ApduDataExtIndividualAddressSerialNumberRead)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtIndividualAddressSerialNumberRead)(nil)

// NewApduDataExtIndividualAddressSerialNumberRead factory function for _ApduDataExtIndividualAddressSerialNumberRead
func NewApduDataExtIndividualAddressSerialNumberRead(length uint8) *_ApduDataExtIndividualAddressSerialNumberRead {
	_result := &_ApduDataExtIndividualAddressSerialNumberRead{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtIndividualAddressSerialNumberReadBuilder is a builder for ApduDataExtIndividualAddressSerialNumberRead
type ApduDataExtIndividualAddressSerialNumberReadBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtIndividualAddressSerialNumberReadBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtIndividualAddressSerialNumberRead or returns an error if something is wrong
	Build() (ApduDataExtIndividualAddressSerialNumberRead, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtIndividualAddressSerialNumberRead
}

// NewApduDataExtIndividualAddressSerialNumberReadBuilder() creates a ApduDataExtIndividualAddressSerialNumberReadBuilder
func NewApduDataExtIndividualAddressSerialNumberReadBuilder() ApduDataExtIndividualAddressSerialNumberReadBuilder {
	return &_ApduDataExtIndividualAddressSerialNumberReadBuilder{_ApduDataExtIndividualAddressSerialNumberRead: new(_ApduDataExtIndividualAddressSerialNumberRead)}
}

type _ApduDataExtIndividualAddressSerialNumberReadBuilder struct {
	*_ApduDataExtIndividualAddressSerialNumberRead

	parentBuilder *_ApduDataExtBuilder

	collectedErr []error
}

var _ (ApduDataExtIndividualAddressSerialNumberReadBuilder) = (*_ApduDataExtIndividualAddressSerialNumberReadBuilder)(nil)

func (b *_ApduDataExtIndividualAddressSerialNumberReadBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtIndividualAddressSerialNumberRead
}

func (b *_ApduDataExtIndividualAddressSerialNumberReadBuilder) WithMandatoryFields() ApduDataExtIndividualAddressSerialNumberReadBuilder {
	return b
}

func (b *_ApduDataExtIndividualAddressSerialNumberReadBuilder) Build() (ApduDataExtIndividualAddressSerialNumberRead, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataExtIndividualAddressSerialNumberRead.deepCopy(), nil
}

func (b *_ApduDataExtIndividualAddressSerialNumberReadBuilder) MustBuild() ApduDataExtIndividualAddressSerialNumberRead {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtIndividualAddressSerialNumberReadBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtIndividualAddressSerialNumberReadBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtIndividualAddressSerialNumberReadBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtIndividualAddressSerialNumberReadBuilder().(*_ApduDataExtIndividualAddressSerialNumberReadBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataExtIndividualAddressSerialNumberReadBuilder creates a ApduDataExtIndividualAddressSerialNumberReadBuilder
func (b *_ApduDataExtIndividualAddressSerialNumberRead) CreateApduDataExtIndividualAddressSerialNumberReadBuilder() ApduDataExtIndividualAddressSerialNumberReadBuilder {
	if b == nil {
		return NewApduDataExtIndividualAddressSerialNumberReadBuilder()
	}
	return &_ApduDataExtIndividualAddressSerialNumberReadBuilder{_ApduDataExtIndividualAddressSerialNumberRead: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtIndividualAddressSerialNumberRead) GetExtApciType() uint8 {
	return 0x1C
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtIndividualAddressSerialNumberRead) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtIndividualAddressSerialNumberRead(structType any) ApduDataExtIndividualAddressSerialNumberRead {
	if casted, ok := structType.(ApduDataExtIndividualAddressSerialNumberRead); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtIndividualAddressSerialNumberRead); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) GetTypeName() string {
	return "ApduDataExtIndividualAddressSerialNumberRead"
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtIndividualAddressSerialNumberRead ApduDataExtIndividualAddressSerialNumberRead, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtIndividualAddressSerialNumberRead"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtIndividualAddressSerialNumberRead")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtIndividualAddressSerialNumberRead"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtIndividualAddressSerialNumberRead")
	}

	return m, nil
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtIndividualAddressSerialNumberRead"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtIndividualAddressSerialNumberRead")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtIndividualAddressSerialNumberRead"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtIndividualAddressSerialNumberRead")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) IsApduDataExtIndividualAddressSerialNumberRead() {
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) deepCopy() *_ApduDataExtIndividualAddressSerialNumberRead {
	if m == nil {
		return nil
	}
	_ApduDataExtIndividualAddressSerialNumberReadCopy := &_ApduDataExtIndividualAddressSerialNumberRead{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtIndividualAddressSerialNumberReadCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtIndividualAddressSerialNumberReadCopy
}

func (m *_ApduDataExtIndividualAddressSerialNumberRead) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
