/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ConfigurationUpdateTargetType is the corresponding interface of ConfigurationUpdateTargetType
type ConfigurationUpdateTargetType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetPath returns Path (property field)
	GetPath() PascalString
	// GetUpdateType returns UpdateType (property field)
	GetUpdateType() ConfigurationUpdateType
	// IsConfigurationUpdateTargetType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsConfigurationUpdateTargetType()
	// CreateBuilder creates a ConfigurationUpdateTargetTypeBuilder
	CreateConfigurationUpdateTargetTypeBuilder() ConfigurationUpdateTargetTypeBuilder
}

// _ConfigurationUpdateTargetType is the data-structure of this message
type _ConfigurationUpdateTargetType struct {
	ExtensionObjectDefinitionContract
	Path       PascalString
	UpdateType ConfigurationUpdateType
}

var _ ConfigurationUpdateTargetType = (*_ConfigurationUpdateTargetType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ConfigurationUpdateTargetType)(nil)

// NewConfigurationUpdateTargetType factory function for _ConfigurationUpdateTargetType
func NewConfigurationUpdateTargetType(path PascalString, updateType ConfigurationUpdateType) *_ConfigurationUpdateTargetType {
	if path == nil {
		panic("path of type PascalString for ConfigurationUpdateTargetType must not be nil")
	}
	_result := &_ConfigurationUpdateTargetType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Path:                              path,
		UpdateType:                        updateType,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ConfigurationUpdateTargetTypeBuilder is a builder for ConfigurationUpdateTargetType
type ConfigurationUpdateTargetTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(path PascalString, updateType ConfigurationUpdateType) ConfigurationUpdateTargetTypeBuilder
	// WithPath adds Path (property field)
	WithPath(PascalString) ConfigurationUpdateTargetTypeBuilder
	// WithPathBuilder adds Path (property field) which is build by the builder
	WithPathBuilder(func(PascalStringBuilder) PascalStringBuilder) ConfigurationUpdateTargetTypeBuilder
	// WithUpdateType adds UpdateType (property field)
	WithUpdateType(ConfigurationUpdateType) ConfigurationUpdateTargetTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ConfigurationUpdateTargetType or returns an error if something is wrong
	Build() (ConfigurationUpdateTargetType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ConfigurationUpdateTargetType
}

// NewConfigurationUpdateTargetTypeBuilder() creates a ConfigurationUpdateTargetTypeBuilder
func NewConfigurationUpdateTargetTypeBuilder() ConfigurationUpdateTargetTypeBuilder {
	return &_ConfigurationUpdateTargetTypeBuilder{_ConfigurationUpdateTargetType: new(_ConfigurationUpdateTargetType)}
}

type _ConfigurationUpdateTargetTypeBuilder struct {
	*_ConfigurationUpdateTargetType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ConfigurationUpdateTargetTypeBuilder) = (*_ConfigurationUpdateTargetTypeBuilder)(nil)

func (b *_ConfigurationUpdateTargetTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ConfigurationUpdateTargetType
}

func (b *_ConfigurationUpdateTargetTypeBuilder) WithMandatoryFields(path PascalString, updateType ConfigurationUpdateType) ConfigurationUpdateTargetTypeBuilder {
	return b.WithPath(path).WithUpdateType(updateType)
}

func (b *_ConfigurationUpdateTargetTypeBuilder) WithPath(path PascalString) ConfigurationUpdateTargetTypeBuilder {
	b.Path = path
	return b
}

func (b *_ConfigurationUpdateTargetTypeBuilder) WithPathBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ConfigurationUpdateTargetTypeBuilder {
	builder := builderSupplier(b.Path.CreatePascalStringBuilder())
	var err error
	b.Path, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ConfigurationUpdateTargetTypeBuilder) WithUpdateType(updateType ConfigurationUpdateType) ConfigurationUpdateTargetTypeBuilder {
	b.UpdateType = updateType
	return b
}

func (b *_ConfigurationUpdateTargetTypeBuilder) Build() (ConfigurationUpdateTargetType, error) {
	if b.Path == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'path' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ConfigurationUpdateTargetType.deepCopy(), nil
}

func (b *_ConfigurationUpdateTargetTypeBuilder) MustBuild() ConfigurationUpdateTargetType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ConfigurationUpdateTargetTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ConfigurationUpdateTargetTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ConfigurationUpdateTargetTypeBuilder) DeepCopy() any {
	_copy := b.CreateConfigurationUpdateTargetTypeBuilder().(*_ConfigurationUpdateTargetTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateConfigurationUpdateTargetTypeBuilder creates a ConfigurationUpdateTargetTypeBuilder
func (b *_ConfigurationUpdateTargetType) CreateConfigurationUpdateTargetTypeBuilder() ConfigurationUpdateTargetTypeBuilder {
	if b == nil {
		return NewConfigurationUpdateTargetTypeBuilder()
	}
	return &_ConfigurationUpdateTargetTypeBuilder{_ConfigurationUpdateTargetType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ConfigurationUpdateTargetType) GetExtensionId() int32 {
	return int32(15540)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ConfigurationUpdateTargetType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ConfigurationUpdateTargetType) GetPath() PascalString {
	return m.Path
}

func (m *_ConfigurationUpdateTargetType) GetUpdateType() ConfigurationUpdateType {
	return m.UpdateType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastConfigurationUpdateTargetType(structType any) ConfigurationUpdateTargetType {
	if casted, ok := structType.(ConfigurationUpdateTargetType); ok {
		return casted
	}
	if casted, ok := structType.(*ConfigurationUpdateTargetType); ok {
		return *casted
	}
	return nil
}

func (m *_ConfigurationUpdateTargetType) GetTypeName() string {
	return "ConfigurationUpdateTargetType"
}

func (m *_ConfigurationUpdateTargetType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (path)
	lengthInBits += m.Path.GetLengthInBits(ctx)

	// Simple field (updateType)
	lengthInBits += 32

	return lengthInBits
}

func (m *_ConfigurationUpdateTargetType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ConfigurationUpdateTargetType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__configurationUpdateTargetType ConfigurationUpdateTargetType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ConfigurationUpdateTargetType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ConfigurationUpdateTargetType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	path, err := ReadSimpleField[PascalString](ctx, "path", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'path' field"))
	}
	m.Path = path

	updateType, err := ReadEnumField[ConfigurationUpdateType](ctx, "updateType", "ConfigurationUpdateType", ReadEnum(ConfigurationUpdateTypeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'updateType' field"))
	}
	m.UpdateType = updateType

	if closeErr := readBuffer.CloseContext("ConfigurationUpdateTargetType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ConfigurationUpdateTargetType")
	}

	return m, nil
}

func (m *_ConfigurationUpdateTargetType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ConfigurationUpdateTargetType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ConfigurationUpdateTargetType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ConfigurationUpdateTargetType")
		}

		if err := WriteSimpleField[PascalString](ctx, "path", m.GetPath(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'path' field")
		}

		if err := WriteSimpleEnumField[ConfigurationUpdateType](ctx, "updateType", "ConfigurationUpdateType", m.GetUpdateType(), WriteEnum[ConfigurationUpdateType, uint32](ConfigurationUpdateType.GetValue, ConfigurationUpdateType.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'updateType' field")
		}

		if popErr := writeBuffer.PopContext("ConfigurationUpdateTargetType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ConfigurationUpdateTargetType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ConfigurationUpdateTargetType) IsConfigurationUpdateTargetType() {}

func (m *_ConfigurationUpdateTargetType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ConfigurationUpdateTargetType) deepCopy() *_ConfigurationUpdateTargetType {
	if m == nil {
		return nil
	}
	_ConfigurationUpdateTargetTypeCopy := &_ConfigurationUpdateTargetType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Path),
		m.UpdateType,
	}
	_ConfigurationUpdateTargetTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ConfigurationUpdateTargetTypeCopy
}

func (m *_ConfigurationUpdateTargetType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
