/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableNaming is an enum
type OpcuaNodeIdServicesVariableNaming int32

type IOpcuaNodeIdServicesVariableNaming interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableNaming_NamingRuleType_EnumValues OpcuaNodeIdServicesVariableNaming = 12169
)

var OpcuaNodeIdServicesVariableNamingValues []OpcuaNodeIdServicesVariableNaming

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableNamingValues = []OpcuaNodeIdServicesVariableNaming{
		OpcuaNodeIdServicesVariableNaming_NamingRuleType_EnumValues,
	}
}

func OpcuaNodeIdServicesVariableNamingByValue(value int32) (enum OpcuaNodeIdServicesVariableNaming, ok bool) {
	switch value {
	case 12169:
		return OpcuaNodeIdServicesVariableNaming_NamingRuleType_EnumValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableNamingByName(value string) (enum OpcuaNodeIdServicesVariableNaming, ok bool) {
	switch value {
	case "NamingRuleType_EnumValues":
		return OpcuaNodeIdServicesVariableNaming_NamingRuleType_EnumValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableNamingKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableNamingValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableNaming(structType any) OpcuaNodeIdServicesVariableNaming {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableNaming {
		if sOpcuaNodeIdServicesVariableNaming, ok := typ.(OpcuaNodeIdServicesVariableNaming); ok {
			return sOpcuaNodeIdServicesVariableNaming
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableNaming) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableNaming) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableNamingParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableNaming, error) {
	return OpcuaNodeIdServicesVariableNamingParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableNamingParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableNaming, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableNaming", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableNaming")
	}
	if enum, ok := OpcuaNodeIdServicesVariableNamingByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableNaming")
		return OpcuaNodeIdServicesVariableNaming(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableNaming) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableNaming) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableNaming", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableNaming) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableNaming) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableNaming_NamingRuleType_EnumValues:
		return "NamingRuleType_EnumValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableNaming) String() string {
	return e.PLC4XEnumName()
}
