/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ApplicationId {
  RESERVED((short) 0x00),
  FREE_USAGE((short) 0x01),
  TEMPERATURE_BROADCAST((short) 0x02),
  ROOM_CONTROL_SYSTEM((short) 0x03),
  LIGHTING((short) 0x04),
  VENTILATION((short) 0x05),
  IRRIGATION_CONTROL((short) 0x06),
  POOLS_SPAS_PONDS_FOUNTAINS_CONTROL((short) 0x07),
  HEATING((short) 0x08),
  AIR_CONDITIONING((short) 0x09),
  TRIGGER_CONTROL((short) 0x0A),
  ENABLE_CONTROL((short) 0x0B),
  AUDIO_AND_VIDEO((short) 0x0C),
  SECURITY((short) 0x0D),
  METERING((short) 0x0E),
  ACCESS_CONTROL((short) 0x0F),
  CLOCK_AND_TIMEKEEPING((short) 0x10),
  TELEPHONY_STATUS_AND_CONTROL((short) 0x11),
  MEASUREMENT((short) 0x12),
  TESTING((short) 0x13),
  MEDIA_TRANSPORT_CONTROL((short) 0x14),
  ERROR_REPORTING((short) 0x15),
  HVAC_ACTUATOR((short) 0x16),
  INFO_MESSAGES((short) 0x17),
  NETWORK_CONTROL((short) 0x18);
  private static final Map<Short, ApplicationId> map;

  static {
    map = new HashMap<>();
    for (ApplicationId value : ApplicationId.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  ApplicationId(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static ApplicationId enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
