/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ApduDataExtPropertyDescriptionRead extends ApduDataExt implements Message {

  // Accessors for discriminator values.
  public Byte getExtApciType() {
    return (byte) 0x18;
  }

  // Properties.
  protected final short objectIndex;
  protected final short propertyId;
  protected final short index;

  public ApduDataExtPropertyDescriptionRead(short objectIndex, short propertyId, short index) {
    super();
    this.objectIndex = objectIndex;
    this.propertyId = propertyId;
    this.index = index;
  }

  public short getObjectIndex() {
    return objectIndex;
  }

  public short getPropertyId() {
    return propertyId;
  }

  public short getIndex() {
    return index;
  }

  @Override
  protected void serializeApduDataExtChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ApduDataExtPropertyDescriptionRead");

    // Simple Field (objectIndex)
    writeSimpleField("objectIndex", objectIndex, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (propertyId)
    writeSimpleField("propertyId", propertyId, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (index)
    writeSimpleField("index", index, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("ApduDataExtPropertyDescriptionRead");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ApduDataExtPropertyDescriptionRead _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (objectIndex)
    lengthInBits += 8;

    // Simple field (propertyId)
    lengthInBits += 8;

    // Simple field (index)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static ApduDataExtBuilder staticParseApduDataExtBuilder(
      ReadBuffer readBuffer, Short length) throws ParseException {
    readBuffer.pullContext("ApduDataExtPropertyDescriptionRead");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short objectIndex = readSimpleField("objectIndex", readUnsignedShort(readBuffer, 8));

    short propertyId = readSimpleField("propertyId", readUnsignedShort(readBuffer, 8));

    short index = readSimpleField("index", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("ApduDataExtPropertyDescriptionRead");
    // Create the instance
    return new ApduDataExtPropertyDescriptionReadBuilderImpl(objectIndex, propertyId, index);
  }

  public static class ApduDataExtPropertyDescriptionReadBuilderImpl
      implements ApduDataExt.ApduDataExtBuilder {
    private final short objectIndex;
    private final short propertyId;
    private final short index;

    public ApduDataExtPropertyDescriptionReadBuilderImpl(
        short objectIndex, short propertyId, short index) {
      this.objectIndex = objectIndex;
      this.propertyId = propertyId;
      this.index = index;
    }

    public ApduDataExtPropertyDescriptionRead build() {
      ApduDataExtPropertyDescriptionRead apduDataExtPropertyDescriptionRead =
          new ApduDataExtPropertyDescriptionRead(objectIndex, propertyId, index);
      return apduDataExtPropertyDescriptionRead;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ApduDataExtPropertyDescriptionRead)) {
      return false;
    }
    ApduDataExtPropertyDescriptionRead that = (ApduDataExtPropertyDescriptionRead) o;
    return (getObjectIndex() == that.getObjectIndex())
        && (getPropertyId() == that.getPropertyId())
        && (getIndex() == that.getIndex())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getObjectIndex(), getPropertyId(), getIndex());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
