/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SzlId implements Message {

  // Properties.
  protected final SzlModuleTypeClass typeClass;
  protected final byte sublistExtract;
  protected final SzlSublist sublistList;

  public SzlId(SzlModuleTypeClass typeClass, byte sublistExtract, SzlSublist sublistList) {
    super();
    this.typeClass = typeClass;
    this.sublistExtract = sublistExtract;
    this.sublistList = sublistList;
  }

  public SzlModuleTypeClass getTypeClass() {
    return typeClass;
  }

  public byte getSublistExtract() {
    return sublistExtract;
  }

  public SzlSublist getSublistList() {
    return sublistList;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SzlId");

    // Simple Field (typeClass)
    writeSimpleEnumField(
        "typeClass",
        "SzlModuleTypeClass",
        typeClass,
        writeEnum(
            SzlModuleTypeClass::getValue,
            SzlModuleTypeClass::name,
            writeUnsignedByte(writeBuffer, 4)));

    // Simple Field (sublistExtract)
    writeSimpleField("sublistExtract", sublistExtract, writeUnsignedByte(writeBuffer, 4));

    // Simple Field (sublistList)
    writeSimpleEnumField(
        "sublistList",
        "SzlSublist",
        sublistList,
        writeEnum(SzlSublist::getValue, SzlSublist::name, writeUnsignedShort(writeBuffer, 8)));

    writeBuffer.popContext("SzlId");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SzlId _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (typeClass)
    lengthInBits += 4;

    // Simple field (sublistExtract)
    lengthInBits += 4;

    // Simple field (sublistList)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static SzlId staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("SzlId");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    SzlModuleTypeClass typeClass =
        readEnumField(
            "typeClass",
            "SzlModuleTypeClass",
            readEnum(SzlModuleTypeClass::enumForValue, readUnsignedByte(readBuffer, 4)));

    byte sublistExtract = readSimpleField("sublistExtract", readUnsignedByte(readBuffer, 4));

    SzlSublist sublistList =
        readEnumField(
            "sublistList",
            "SzlSublist",
            readEnum(SzlSublist::enumForValue, readUnsignedShort(readBuffer, 8)));

    readBuffer.closeContext("SzlId");
    // Create the instance
    SzlId _szlId;
    _szlId = new SzlId(typeClass, sublistExtract, sublistList);
    return _szlId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SzlId)) {
      return false;
    }
    SzlId that = (SzlId) o;
    return (getTypeClass() == that.getTypeClass())
        && (getSublistExtract() == that.getSublistExtract())
        && (getSublistList() == that.getSublistList())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getTypeClass(), getSublistExtract(), getSublistList());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
