/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerTagsAllPresentConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerTagsAllPresentConditionEvaluator.class);
    private final Set<String> policyConditionTags = new HashSet<String>();

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagsAllPresentConditionEvaluator.init(" + this.condition + ")");
        }
        super.init();
        if (this.condition != null) {
            for (String value : this.condition.getValues()) {
                this.policyConditionTags.add(value.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagsAllPresentConditionEvaluator.init(" + this.condition + "): Tags[" + this.policyConditionTags + "]");
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagsAllPresentConditionEvaluator.isMatched(" + request + ")");
        }
        boolean matched = true;
        if (CollectionUtils.isNotEmpty(this.policyConditionTags)) {
            Set<RangerTagForEval> resourceTags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
            if (CollectionUtils.isNotEmpty(resourceTags)) {
                HashSet<String> tags = new HashSet<String>(resourceTags.size());
                for (RangerTagForEval tag : resourceTags) {
                    tags.add(tag.getType());
                }
                matched = tags.containsAll(this.policyConditionTags);
            } else {
                matched = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagsAllPresentConditionEvaluator.isMatched(" + request + "): " + matched);
        }
        return matched;
    }
}

