/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ranger.plugin.model.RangerPrincipal;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.model.RangerSecurityZoneV2;

public class RangerSecurityZoneHelper {
    private final RangerSecurityZone zone;
    private final String currentUser;
    private final Map<String, RangerSecurityZoneServiceHelper> services;

    public RangerSecurityZoneHelper(RangerSecurityZone zone, String currentUser) {
        this.zone = zone;
        this.currentUser = currentUser;
        this.services = new HashMap<String, RangerSecurityZoneServiceHelper>();
        for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> entry : zone.getServices().entrySet()) {
            this.services.put(entry.getKey(), new RangerSecurityZoneServiceHelper(entry.getValue(), currentUser));
        }
    }

    public RangerSecurityZone getZone() {
        return this.zone;
    }

    public RangerSecurityZoneServiceHelper getZoneService(String serviceName) {
        return this.services.get(serviceName);
    }

    public RangerSecurityZoneServiceHelper addZoneService(String serviceName) {
        RangerSecurityZoneServiceHelper ret = this.services.get(serviceName);
        if (ret == null) {
            RangerSecurityZone.RangerSecurityZoneService zoneService = this.zone.getServices().get(serviceName);
            if (zoneService == null) {
                zoneService = new RangerSecurityZone.RangerSecurityZoneService();
                this.zone.getServices().put(serviceName, zoneService);
            }
            ret = new RangerSecurityZoneServiceHelper(zoneService, this.currentUser);
            this.services.put(serviceName, ret);
        }
        return ret;
    }

    public void removeService(String serviceName) {
        this.services.remove(serviceName);
        this.zone.getServices().remove(serviceName);
    }

    public RangerSecurityZone updateZone(RangerSecurityZoneV2.RangerSecurityZoneChangeRequest changeData) throws Exception {
        RangerSecurityZoneServiceHelper zoneServiceHelper;
        RangerSecurityZoneV2.RangerSecurityZoneServiceV2 zoneService;
        String serviceName;
        if (changeData.getName() != null) {
            this.zone.setName(changeData.getName());
        }
        if (changeData.getDescription() != null) {
            this.zone.setDescription(changeData.getDescription());
        }
        if (changeData.getResourcesToUpdate() != null) {
            for (Map.Entry<String, RangerSecurityZoneV2.RangerSecurityZoneServiceV2> entry : changeData.getResourcesToUpdate().entrySet()) {
                serviceName = entry.getKey();
                zoneService = entry.getValue();
                zoneServiceHelper = this.addZoneService(serviceName);
                if (zoneService == null || zoneService.getResources() == null) continue;
                for (RangerSecurityZoneV2.RangerSecurityZoneResource resource : zoneService.getResources()) {
                    if (resource == null) continue;
                    zoneServiceHelper.updateResource(resource);
                }
            }
        }
        if (changeData.getResourcesToRemove() != null) {
            for (Map.Entry entry : changeData.getResourcesToRemove().entrySet()) {
                serviceName = (String)entry.getKey();
                zoneService = (RangerSecurityZoneV2.RangerSecurityZoneServiceV2)entry.getValue();
                zoneServiceHelper = this.getZoneService(serviceName);
                if (zoneServiceHelper != null && zoneService != null && zoneService.getResources() != null) {
                    for (RangerSecurityZoneV2.RangerSecurityZoneResource resource : zoneService.getResources()) {
                        RangerSecurityZoneV2.RangerSecurityZoneResource removedResource;
                        if (resource == null || (removedResource = resource.getId() != null ? zoneServiceHelper.removeResource(resource.getId()) : (resource.getResource() != null ? zoneServiceHelper.removeResource(resource.getResource()) : null)) != null) continue;
                        throw new Exception(resource + ": resource not in zone");
                    }
                    if (zoneServiceHelper.getResourceCount() != 0) continue;
                    this.removeService(serviceName);
                    continue;
                }
                throw new Exception(serviceName + ": service not in zone");
            }
        }
        if (changeData.getTagServicesToAdd() != null) {
            for (String string : changeData.getTagServicesToAdd()) {
                if (this.addIfAbsent(string, this.zone.getTagServices())) continue;
                throw new Exception(string + ": tag service already exists in zone");
            }
        }
        if (changeData.getTagServicesToRemove() != null) {
            for (String string : changeData.getTagServicesToRemove()) {
                if (this.zone.getTagServices().remove(string)) continue;
                throw new Exception(string + ": tag service not in zone");
            }
        }
        if (changeData.getAdminsToAdd() != null) {
            this.addPrincipals(changeData.getAdminsToAdd(), this.zone.getAdminUsers(), this.zone.getAdminUserGroups(), this.zone.getAdminRoles());
        }
        if (changeData.getAdminsToRemove() != null) {
            this.removePrincipals(changeData.getAdminsToRemove(), this.zone.getAdminUsers(), this.zone.getAdminUserGroups(), this.zone.getAdminRoles());
        }
        if (changeData.getAuditorsToAdd() != null) {
            this.addPrincipals(changeData.getAuditorsToAdd(), this.zone.getAuditUsers(), this.zone.getAuditUserGroups(), this.zone.getAuditRoles());
        }
        if (changeData.getAuditorsToRemove() != null) {
            this.removePrincipals(changeData.getAuditorsToRemove(), this.zone.getAuditUsers(), this.zone.getAuditUserGroups(), this.zone.getAuditRoles());
        }
        return this.zone;
    }

    private void addPrincipals(List<RangerPrincipal> principals, List<String> users, List<String> groups, List<String> roles) throws Exception {
        for (RangerPrincipal principal : principals) {
            boolean isAdded = false;
            if (principal.getType() == RangerPrincipal.PrincipalType.USER) {
                isAdded = this.addIfAbsent(principal.getName(), users);
            } else if (principal.getType() == RangerPrincipal.PrincipalType.GROUP) {
                isAdded = this.addIfAbsent(principal.getName(), groups);
            } else if (principal.getType() == RangerPrincipal.PrincipalType.ROLE) {
                isAdded = this.addIfAbsent(principal.getName(), roles);
            }
            if (isAdded) continue;
            throw new Exception(principal + ": principal already an admin or auditor in zone");
        }
    }

    private void removePrincipals(List<RangerPrincipal> principals, List<String> users, List<String> groups, List<String> roles) throws Exception {
        for (RangerPrincipal principal : principals) {
            boolean isRemoved = false;
            if (principal.getType() == RangerPrincipal.PrincipalType.USER) {
                isRemoved = users.remove(principal.getName());
            } else if (principal.getType() == RangerPrincipal.PrincipalType.GROUP) {
                isRemoved = groups.remove(principal.getName());
            } else if (principal.getType() == RangerPrincipal.PrincipalType.ROLE) {
                isRemoved = roles.remove(principal.getName());
            }
            if (isRemoved) continue;
            throw new Exception(principal + ": principal not an admin or auditor in zone");
        }
    }

    private boolean addIfAbsent(String item, List<String> lst) {
        boolean ret = !lst.contains(item) ? lst.add(item) : false;
        return ret;
    }

    public static class RangerSecurityZoneServiceHelper {
        private final RangerSecurityZone.RangerSecurityZoneService zoneService;
        private final String currentUser;
        private final List<HashMap<String, List<String>>> resources;
        private final List<RangerSecurityZoneV2.RangerSecurityZoneResourceBase> resourcesBaseInfo;
        private long nextResourceId = 1L;

        public RangerSecurityZoneServiceHelper(RangerSecurityZone.RangerSecurityZoneService zoneService, String currentUser) {
            int i;
            this.zoneService = zoneService;
            this.currentUser = currentUser;
            if (zoneService.getResources() != null) {
                this.resources = zoneService.getResources();
            } else {
                this.resources = new ArrayList<HashMap<String, List<String>>>();
                zoneService.setResources(this.resources);
            }
            if (zoneService.getResourcesBaseInfo() != null) {
                this.resourcesBaseInfo = zoneService.getResourcesBaseInfo();
            } else {
                this.resourcesBaseInfo = new ArrayList<RangerSecurityZoneV2.RangerSecurityZoneResourceBase>();
                zoneService.setResourcesBaseInfo(this.resourcesBaseInfo);
            }
            for (RangerSecurityZoneV2.RangerSecurityZoneResourceBase baseInfo : this.resourcesBaseInfo) {
                if (baseInfo.getId() == null || this.nextResourceId > baseInfo.getId()) continue;
                this.nextResourceId = baseInfo.getId() + 1L;
            }
            for (i = this.resourcesBaseInfo.size(); i < this.resources.size(); ++i) {
                RangerSecurityZoneV2.RangerSecurityZoneResourceBase baseInfo;
                baseInfo = new RangerSecurityZoneV2.RangerSecurityZoneResourceBase();
                this.setCreated(baseInfo);
                this.resourcesBaseInfo.add(baseInfo);
            }
            i = this.resources.size();
            while (i < this.resourcesBaseInfo.size()) {
                this.resourcesBaseInfo.remove(i);
            }
            for (RangerSecurityZoneV2.RangerSecurityZoneResourceBase baseInfo : this.resourcesBaseInfo) {
                if (baseInfo.getId() != null) continue;
                baseInfo.setId(this.nextResourceId++);
            }
        }

        public RangerSecurityZone.RangerSecurityZoneService getZoneService() {
            return this.zoneService;
        }

        public int getResourceCount() {
            return this.resources != null ? this.resources.size() : 0;
        }

        public List<RangerSecurityZoneV2.RangerSecurityZoneResource> getResources() {
            ArrayList<RangerSecurityZoneV2.RangerSecurityZoneResource> ret = new ArrayList<RangerSecurityZoneV2.RangerSecurityZoneResource>();
            if (this.resources != null) {
                for (int i = 0; i < this.resources.size(); ++i) {
                    ret.add(this.getResourceAt(i));
                }
            }
            return Collections.unmodifiableList(ret);
        }

        public List<RangerSecurityZoneV2.RangerSecurityZoneResource> getResources(int startIdx, int count) {
            ArrayList<RangerSecurityZoneV2.RangerSecurityZoneResource> ret = new ArrayList<RangerSecurityZoneV2.RangerSecurityZoneResource>();
            if (this.resources != null) {
                RangerSecurityZoneV2.RangerSecurityZoneResource resource;
                for (int i = 0; i < count && (resource = this.getResourceAt(startIdx + i)) != null; ++i) {
                    ret.add(resource);
                }
            }
            return Collections.unmodifiableList(ret);
        }

        public RangerSecurityZoneV2.RangerSecurityZoneResource getResource(long id) {
            int idx = this.getResourceIdx(id);
            return idx != -1 ? this.getResourceAt(idx) : null;
        }

        public RangerSecurityZoneV2.RangerSecurityZoneResource getResource(Map<String, List<String>> resource) {
            int idx = this.getResourceIdx(resource);
            return idx != -1 ? this.getResourceAt(idx) : null;
        }

        public RangerSecurityZoneV2.RangerSecurityZoneResource addResource(RangerSecurityZoneV2.RangerSecurityZoneResource resource) {
            this.setCreated(resource);
            this.resources.add((HashMap)resource.getResource());
            this.resourcesBaseInfo.add(new RangerSecurityZoneV2.RangerSecurityZoneResourceBase(resource));
            return resource;
        }

        public RangerSecurityZoneV2.RangerSecurityZoneResource updateResource(RangerSecurityZoneV2.RangerSecurityZoneResource resource) {
            int resourceIdx;
            Long resourceId = resource.getId();
            int n = resourceIdx = resourceId != null ? this.getResourceIdx(resourceId) : -1;
            if (resourceIdx == -1) {
                this.addResource(resource);
            } else {
                this.setUpdated(resource, resourceIdx);
                this.resources.set(resourceIdx, (HashMap)resource.getResource());
                this.resourcesBaseInfo.set(resourceIdx, new RangerSecurityZoneV2.RangerSecurityZoneResourceBase(resource));
            }
            return resource;
        }

        public RangerSecurityZoneV2.RangerSecurityZoneResource removeResource(long id) {
            int idx = this.getResourceIdx(id);
            return idx != -1 ? this.removeResourceAt(idx) : null;
        }

        public RangerSecurityZoneV2.RangerSecurityZoneResource removeResource(Map<String, List<String>> resource) {
            int idx = this.getResourceIdx(resource);
            return idx != -1 ? this.removeResourceAt(idx) : null;
        }

        private RangerSecurityZoneV2.RangerSecurityZoneResource getResourceAt(int idx) {
            RangerSecurityZoneV2.RangerSecurityZoneResourceBase resourceBaseInfo;
            RangerSecurityZoneV2.RangerSecurityZoneResource ret = null;
            HashMap<String, List<String>> resource = this.resources != null && this.resources.size() > idx ? this.resources.get(idx) : null;
            RangerSecurityZoneV2.RangerSecurityZoneResourceBase rangerSecurityZoneResourceBase = resourceBaseInfo = this.resourcesBaseInfo != null && this.resourcesBaseInfo.size() > idx ? this.resourcesBaseInfo.get(idx) : null;
            if (resource != null) {
                ret = new RangerSecurityZoneV2.RangerSecurityZoneResource(resource, resourceBaseInfo);
            }
            return ret;
        }

        private RangerSecurityZoneV2.RangerSecurityZoneResource removeResourceAt(int idx) {
            RangerSecurityZoneV2.RangerSecurityZoneResourceBase resourceBaseInfo;
            RangerSecurityZoneV2.RangerSecurityZoneResource ret = null;
            HashMap<String, List<String>> resource = this.resources != null && this.resources.size() > idx ? this.resources.remove(idx) : null;
            RangerSecurityZoneV2.RangerSecurityZoneResourceBase rangerSecurityZoneResourceBase = resourceBaseInfo = this.resourcesBaseInfo != null && this.resourcesBaseInfo.size() > idx ? this.resourcesBaseInfo.remove(idx) : null;
            if (resource != null) {
                ret = new RangerSecurityZoneV2.RangerSecurityZoneResource(resource, resourceBaseInfo);
            }
            return ret;
        }

        private int getResourceIdx(long id) {
            int ret = -1;
            if (this.resourcesBaseInfo != null) {
                for (int i = 0; i < this.resourcesBaseInfo.size(); ++i) {
                    RangerSecurityZoneV2.RangerSecurityZoneResourceBase baseInfo = this.resourcesBaseInfo.get(i);
                    if (baseInfo == null || baseInfo.getId() == null || !baseInfo.getId().equals(id)) continue;
                    ret = i;
                    break;
                }
            }
            return ret;
        }

        private int getResourceIdx(Map<String, List<String>> resource) {
            int ret = -1;
            if (this.resources != null) {
                for (int i = 0; i < this.resources.size(); ++i) {
                    HashMap<String, List<String>> res = this.resources.get(i);
                    if (!Objects.equals(resource, res)) continue;
                    ret = i;
                    break;
                }
            }
            return ret;
        }

        private void setCreated(RangerSecurityZoneV2.RangerSecurityZoneResourceBase baseInfo) {
            baseInfo.setId(this.nextResourceId++);
            baseInfo.setCreatedBy(this.currentUser);
            baseInfo.setCreateTime(new Date());
            baseInfo.setUpdatedBy(this.currentUser);
            baseInfo.setUpdateTime(new Date());
        }

        private void setUpdated(RangerSecurityZoneV2.RangerSecurityZoneResourceBase baseInfo, int idx) {
            RangerSecurityZoneV2.RangerSecurityZoneResourceBase resourceBase;
            RangerSecurityZoneV2.RangerSecurityZoneResourceBase rangerSecurityZoneResourceBase = resourceBase = this.resourcesBaseInfo != null && this.resourcesBaseInfo.size() > idx ? this.resourcesBaseInfo.get(idx) : null;
            if (resourceBase != null) {
                baseInfo.setId(resourceBase.getId());
                baseInfo.setCreatedBy(resourceBase.getCreatedBy());
                baseInfo.setCreateTime(resourceBase.getCreateTime());
            }
            baseInfo.setUpdatedBy(this.currentUser);
            baseInfo.setUpdateTime(new Date());
        }
    }
}

