/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.shaded.com.google.common.base.Stopwatch;
import org.apache.rocketmq.shaded.com.google.protobuf.Timestamp;

public class MessageCommon {
    @Nullable
    private final MessageId messageId;
    private final String topic;
    private final byte[] body;
    private final Map<String, String> properties;
    @Nullable
    private final String tag;
    private final Collection<String> keys;
    @Nullable
    private final String messageGroup;
    @Nullable
    private final Long deliveryTimestamp;
    @Nullable
    private final String bornHost;
    @Nullable
    private final String parentTraceContext;
    @Nullable
    private final String traceContext;
    @Nullable
    private final Long bornTimestamp;
    @Nullable
    private final Integer deliveryAttempt;
    @Nullable
    private final Stopwatch decodeStopwatch;
    @Nullable
    private final Timestamp deliveryTimestampFromRemote;

    public MessageCommon(String topic, byte[] body, String tag, String messageGroup, Long deliveryTimestamp, String parentTraceContext, Collection<String> keys, Map<String, String> properties) {
        this(null, topic, body, properties, tag, keys, messageGroup, deliveryTimestamp, null, parentTraceContext, null, null, null, null, null);
    }

    public MessageCommon(MessageId messageId, String topic, byte[] body, String tag, String messageGroup, Long deliveryTimestamp, Collection<String> keys, Map<String, String> properties, String bornHost, String traceContext, long bornTimestamp, int deliveryAttempt, Stopwatch decodeStopwatch, Timestamp deliveryTimestampFromRemote) {
        this(messageId, topic, body, properties, tag, keys, messageGroup, deliveryTimestamp, bornHost, null, traceContext, bornTimestamp, deliveryAttempt, decodeStopwatch, deliveryTimestampFromRemote);
    }

    private MessageCommon(@Nullable MessageId messageId, String topic, byte[] body, Map<String, String> properties, @Nullable String tag, Collection<String> keys, @Nullable String messageGroup, @Nullable Long deliveryTimestamp, @Nullable String bornHost, @Nullable String parentTraceContext, @Nullable String traceContext, @Nullable Long bornTimestamp, @Nullable Integer deliveryAttempt, @Nullable Stopwatch decodeStopwatch, @Nullable Timestamp deliveryTimestampFromRemote) {
        this.messageId = messageId;
        this.topic = topic;
        this.body = body;
        this.properties = properties;
        this.tag = tag;
        this.keys = keys;
        this.messageGroup = messageGroup;
        this.deliveryTimestamp = deliveryTimestamp;
        this.bornHost = bornHost;
        this.parentTraceContext = parentTraceContext;
        this.traceContext = traceContext;
        this.bornTimestamp = bornTimestamp;
        this.deliveryAttempt = deliveryAttempt;
        this.decodeStopwatch = decodeStopwatch;
        this.deliveryTimestampFromRemote = deliveryTimestampFromRemote;
    }

    public Optional<MessageId> getMessageId() {
        return null == this.messageId ? Optional.empty() : Optional.of(this.messageId);
    }

    public String getTopic() {
        return this.topic;
    }

    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.body).asReadOnlyBuffer();
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public Optional<String> getTag() {
        return null == this.tag ? Optional.empty() : Optional.of(this.tag);
    }

    public Collection<String> getKeys() {
        return this.keys;
    }

    public Optional<String> getMessageGroup() {
        return null == this.messageGroup ? Optional.empty() : Optional.of(this.messageGroup);
    }

    public Optional<Long> getDeliveryTimestamp() {
        return null == this.deliveryTimestamp ? Optional.empty() : Optional.of(this.deliveryTimestamp);
    }

    public Optional<String> getBornHost() {
        return null == this.bornHost ? Optional.empty() : Optional.of(this.bornHost);
    }

    public Optional<String> getParentTraceContext() {
        return null == this.parentTraceContext ? Optional.empty() : Optional.of(this.parentTraceContext);
    }

    public Optional<String> getTraceContext() {
        return null == this.traceContext ? Optional.empty() : Optional.of(this.traceContext);
    }

    public Optional<Long> getBornTimestamp() {
        return null == this.bornTimestamp ? Optional.empty() : Optional.of(this.bornTimestamp);
    }

    public Optional<Integer> getDeliveryAttempt() {
        return null == this.deliveryAttempt ? Optional.empty() : Optional.of(this.deliveryAttempt);
    }

    public Optional<Duration> getDurationAfterDecoding() {
        return null == this.decodeStopwatch ? Optional.empty() : Optional.of(this.decodeStopwatch.elapsed());
    }

    public Optional<Timestamp> getDeliveryTimestampFromRemote() {
        return null == this.deliveryTimestampFromRemote ? Optional.empty() : Optional.of(this.deliveryTimestampFromRemote);
    }
}

