/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.misc;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.client.java.misc.ExecutorServices;
import org.apache.rocketmq.client.java.misc.ThreadFactoryImpl;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.AbstractIdleService;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public abstract class Dispatcher
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dispatcher.class);
    private final String clientId;
    private final AtomicBoolean dispatched;
    private final ThreadPoolExecutor dispatcherExecutor;

    public Dispatcher(String clientId) {
        this.clientId = clientId;
        this.dispatched = new AtomicBoolean(false);
        this.dispatcherExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("Dispatcher"));
    }

    @Override
    public void startUp() {
    }

    @Override
    public void shutDown() throws InterruptedException {
        this.dispatcherExecutor.shutdown();
        if (!ExecutorServices.awaitTerminated(this.dispatcherExecutor)) {
            LOGGER.error("[Bug] Failed to shutdown the batch dispatcher, clientId={}", (Object)this.clientId);
        }
    }

    public abstract void dispatch();

    public void signal() {
        block3: {
            if (this.dispatched.compareAndSet(false, true)) {
                try {
                    this.dispatcherExecutor.submit(() -> {
                        this.dispatched.compareAndSet(true, false);
                        try {
                            this.dispatch();
                        }
                        catch (Throwable t) {
                            LOGGER.error("Exception raised while dispatching task, clientId={}", (Object)this.clientId, (Object)t);
                        }
                    });
                }
                catch (Throwable t) {
                    if (this.dispatcherExecutor.isShutdown()) break block3;
                    LOGGER.error("[Bug] Failed to submit dispatch task, clientId={}", (Object)this.clientId, (Object)t);
                }
            }
        }
    }
}

