/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.rx;

import org.springframework.cloud.netflix.rx.DeferredResultSubscriber;
import org.springframework.util.Assert;
import org.springframework.web.context.request.async.DeferredResult;
import rx.Single;

class SingleDeferredResult<T>
extends DeferredResult<T> {
    public SingleDeferredResult(Single<T> single) {
        this.initSingle(single);
    }

    public SingleDeferredResult(long timeout, Single<T> single) {
        super(Long.valueOf(timeout));
        this.initSingle(single);
    }

    public SingleDeferredResult(Long timeout, Object timeoutResult, Single<T> single) {
        super(timeout, timeoutResult);
        this.initSingle(single);
    }

    private void initSingle(Single<T> single) {
        Assert.notNull(single, (String)"single can not be null");
        new DeferredResultSubscriber(single.toObservable(), this);
    }
}

