/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetricManager;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultTcpSocketMetric;

public class DefaultTcpClientMetrics
implements TCPMetrics<DefaultTcpSocketMetric> {
    private static final String PROTOCOL = "tcp://";
    private final DefaultClientEndpointMetricManager clientEndpointMetricManager;

    public DefaultTcpClientMetrics(DefaultClientEndpointMetricManager clientEndpointMetricManager) {
        this.clientEndpointMetricManager = clientEndpointMetricManager;
    }

    public DefaultTcpSocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        DefaultClientEndpointMetric endpointMetric = this.clientEndpointMetricManager.getOrCreateEndpointMetric(PROTOCOL + remoteAddress.toString());
        DefaultTcpSocketMetric socketMetric = new DefaultTcpSocketMetric(endpointMetric);
        socketMetric.onConnect();
        return socketMetric;
    }

    public void disconnected(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.onDisconnect();
    }

    public void bytesRead(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.getEndpointMetric().addBytesRead(numberOfBytes);
    }

    public void bytesWritten(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.getEndpointMetric().addBytesWritten(numberOfBytes);
    }
}

