/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.model;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;

public class SwaggerOperations {
    private final OpenAPI swagger;
    private final Map<String, SwaggerOperation> operations = new HashMap<String, SwaggerOperation>();

    public static SwaggerOperations generate(Class<?> cls) {
        OpenAPI swagger = SwaggerGenerator.create(cls).generate();
        return new SwaggerOperations(swagger);
    }

    public SwaggerOperations(OpenAPI swagger) {
        this.swagger = swagger;
        Paths paths = swagger.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        for (Map.Entry pathEntry : paths.entrySet()) {
            for (Map.Entry operationEntry : ((PathItem)pathEntry.getValue()).readOperationsMap().entrySet()) {
                if (StringUtils.isEmpty((CharSequence)((Operation)operationEntry.getValue()).getOperationId())) {
                    throw new IllegalStateException(String.format("OperationId can not be empty, path=%s, httpMethod=%s.", pathEntry.getKey(), operationEntry.getKey()));
                }
                SwaggerOperation swaggerOperation = new SwaggerOperation(swagger, (String)pathEntry.getKey(), (PathItem.HttpMethod)operationEntry.getKey(), (Operation)operationEntry.getValue());
                if (this.operations.putIfAbsent(((Operation)operationEntry.getValue()).getOperationId(), swaggerOperation) == null) continue;
                throw new IllegalStateException("please make sure operationId is unique, duplicated operationId is " + ((Operation)operationEntry.getValue()).getOperationId());
            }
        }
    }

    public OpenAPI getSwagger() {
        return this.swagger;
    }

    public SwaggerOperation findOperation(String operationId) {
        return this.operations.get(operationId);
    }

    public Map<String, SwaggerOperation> getOperations() {
        return this.operations;
    }
}

