/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;

public class LocalHostAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        builder.append(accessLogEvent.getLocalAddress());
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        RestClientRequest restRequestImpl = (RestClientRequest)finishEvent.getInvocation().getHandlerContext().get("servicecomb-invocation-handler-requestclient");
        if (null == restRequestImpl || null == restRequestImpl.getHttpClientRequest() || null == restRequestImpl.getHttpClientRequest().connection() || null == restRequestImpl.getHttpClientRequest().connection().localAddress() || StringUtils.isEmpty((CharSequence)restRequestImpl.getHttpClientRequest().connection().localAddress().host())) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(restRequestImpl.getHttpClientRequest().connection().localAddress().host());
    }

    public static String getLocalAddress(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (null == request || null == request.localAddress() || StringUtils.isEmpty((CharSequence)request.localAddress().host())) {
            return EMPTY_RESULT;
        }
        return request.localAddress().host();
    }
}

