/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.match;

import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.marker.RequestProcessor;
import org.apache.servicecomb.router.cache.RouterRuleCache;
import org.apache.servicecomb.router.model.PolicyRuleItem;

public class RouterRuleMatcher {
    private final RouterRuleCache routerRuleCache;
    private final RequestProcessor requestProcessor;

    public RouterRuleMatcher(RouterRuleCache routerRuleCache, RequestProcessor requestProcessor) {
        this.routerRuleCache = routerRuleCache;
        this.requestProcessor = requestProcessor;
    }

    public PolicyRuleItem match(String serviceName, GovernanceRequestExtractor request) {
        for (PolicyRuleItem rule : this.routerRuleCache.getServiceInfoCacheMap().get(serviceName).getAllrule()) {
            if (rule.getMatch() != null && !this.requestProcessor.match(request, rule.getMatch())) continue;
            return rule;
        }
        return null;
    }
}

