/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import com.google.common.eventbus.Subscribe;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.client.http.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceInstancePing;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.serviceregistry.task.event.MicroserviceNotExistEvent;
import org.apache.servicecomb.serviceregistry.task.event.PullMicroserviceVersionsInstancesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceVersions {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceVersions.class);
    protected AppManager appManager;
    private String appId;
    private String microserviceName;
    private String revision = null;
    private List<MicroserviceInstance> pulledInstances;
    List<MicroserviceInstance> instances;
    Map<String, MicroserviceVersion> versions = new ConcurrentHashMapEx();
    Map<String, MicroserviceVersionRule> versionRules = new ConcurrentHashMapEx();
    private final Object lock = new Object();
    private AtomicInteger pendingPullCount = new AtomicInteger();
    boolean validated = false;

    public MicroserviceVersions(AppManager appManager, String appId, String microserviceName) {
        this.appManager = appManager;
        this.appId = appId;
        this.microserviceName = microserviceName;
        LOGGER.info("create MicroserviceVersions, appId={}, microserviceName={}.", (Object)appId, (Object)microserviceName);
        appManager.getEventBus().register((Object)this);
    }

    public boolean isValidated() {
        return this.validated;
    }

    public AppManager getAppManager() {
        return this.appManager;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public Map<String, MicroserviceVersion> getVersions() {
        return this.versions;
    }

    public <T extends MicroserviceVersion> T getVersion(String serviceId) {
        return (T)this.versions.get(serviceId);
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public List<MicroserviceInstance> getPulledInstances() {
        return this.pulledInstances;
    }

    public void submitPull() {
        this.pendingPullCount.incrementAndGet();
        this.pullInstances();
    }

    public void pullInstances() {
        if (this.pendingPullCount.decrementAndGet() != 0) {
            return;
        }
        MicroserviceInstances microserviceInstances = RegistryUtils.findServiceInstances(this.appId, this.microserviceName, "0.0.0+", this.revision);
        if (microserviceInstances == null) {
            return;
        }
        if (microserviceInstances.isMicroserviceNotExist()) {
            this.appManager.getEventBus().post((Object)new MicroserviceNotExistEvent(this.appId, this.microserviceName));
            return;
        }
        if (!microserviceInstances.isNeedRefresh()) {
            return;
        }
        this.pulledInstances = microserviceInstances.getInstancesResponse().getInstances();
        this.pulledInstances.sort(Comparator.comparing(MicroserviceInstance::getInstanceId));
        String rev = microserviceInstances.getRevision();
        this.safeSetInstances(this.pulledInstances, rev);
    }

    protected void safeSetInstances(List<MicroserviceInstance> pulledInstances, String rev) {
        try {
            this.setInstances(pulledInstances, rev);
            this.validated = true;
        }
        catch (Throwable e) {
            LOGGER.error("Failed to setInstances, appId={}, microserviceName={}.", new Object[]{this.getAppId(), this.getMicroserviceName(), e});
        }
    }

    private void postPullInstanceEvent(long msTime) {
        this.pendingPullCount.incrementAndGet();
        this.appManager.getEventBus().post((Object)new PullMicroserviceVersionsInstancesEvent(this, msTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstances(List<MicroserviceInstance> pulledInstances, String rev) {
        Object object = this.lock;
        synchronized (object) {
            this.instances = this.mergeInstances(pulledInstances, this.instances);
            for (MicroserviceInstance instance : this.instances) {
                this.versions.computeIfAbsent(instance.getServiceId(), microserviceId -> this.appManager.getMicroserviceVersionFactory().create(this.microserviceName, (String)microserviceId));
            }
            for (MicroserviceVersionRule microserviceVersionRule : this.versionRules.values()) {
                microserviceVersionRule.update(this.versions, this.instances);
            }
            this.revision = rev;
        }
    }

    private List<MicroserviceInstance> mergeInstances(List<MicroserviceInstance> pulledInstances, List<MicroserviceInstance> inUseInstances) {
        List<MicroserviceInstance> upInstances = pulledInstances.stream().collect(Collectors.toList());
        if (upInstances.isEmpty() && inUseInstances != null && ServiceRegistryConfig.INSTANCE.isEmptyInstanceProtectionEnabled()) {
            MicroserviceInstancePing ping = (MicroserviceInstancePing)SPIServiceUtils.getPriorityHighestService(MicroserviceInstancePing.class);
            inUseInstances.stream().forEach(instance -> {
                if (!upInstances.contains(instance) && ping.ping((MicroserviceInstance)instance)) {
                    upInstances.add((MicroserviceInstance)instance);
                }
            });
        }
        return upInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String versionRule) {
        MicroserviceVersionRule microserviceVersionRule = this.versionRules.get(versionRule);
        if (microserviceVersionRule == null) {
            Object object = this.lock;
            synchronized (object) {
                microserviceVersionRule = this.versionRules.computeIfAbsent(versionRule, this::createAndInitMicroserviceVersionRule);
            }
        }
        return microserviceVersionRule;
    }

    protected MicroserviceVersionRule createAndInitMicroserviceVersionRule(String strVersionRule) {
        LOGGER.info("create MicroserviceVersionRule, appId={}, microserviceName={}, versionRule={}.", new Object[]{this.appId, this.microserviceName, strVersionRule});
        MicroserviceVersionRule microserviceVersionRule = new MicroserviceVersionRule(this.appId, this.microserviceName, strVersionRule);
        microserviceVersionRule.update(this.versions, this.instances);
        return microserviceVersionRule;
    }

    @Subscribe
    public void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent changedEvent) {
        if (!this.isEventAccept(changedEvent)) {
            return;
        }
        this.postPullInstanceEvent(0L);
    }

    protected boolean isEventAccept(MicroserviceInstanceChangedEvent changedEvent) {
        return this.appId.equals(changedEvent.getKey().getAppId()) && this.microserviceName.equals(changedEvent.getKey().getServiceName()) || this.microserviceName.equals(changedEvent.getKey().getAppId() + ":" + changedEvent.getKey().getServiceName());
    }
}

