/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.encoding.EncodingHeadersKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.EncodingValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.EncodingValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.HeaderValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.encoding.EncodingHeadersValuesValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultEncodingValidatorFactory
implements EncodingValidatorFactory {
    private final HeaderValidatorFactory headerValidatorFactory;

    public DefaultEncodingValidatorFactory(HeaderValidatorFactory headerValidatorFactory) {
        this.headerValidatorFactory = headerValidatorFactory;
    }

    public List<EncodingValidator> create(FactoryOptions options) {
        ArrayList<EncodingValidator> validators = new ArrayList<EncodingValidator>();
        validators.add((EncodingValidator)new EncodingHeadersValuesValidator(this.headerValidatorFactory.create(options)));
        this.addEncodingHeadersKeysCaseValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addEncodingHeadersKeysCaseValidator(List<EncodingValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("encoding.headers.key.case");
        if (expectedCase != null) {
            validators.add((EncodingValidator)new EncodingHeadersKeysCaseValidator(expectedCase));
        }
    }
}

