/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.cli;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.servicecomb.toolkit.DocGenerator;
import org.apache.servicecomb.toolkit.GeneratorFactory;
import org.apache.servicecomb.toolkit.cli.CodeGenerate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="docgenerate", description="Generate document by OpenAPI specification file")
public class DocGenerate
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeGenerate.class);
    @Option(name={"-i", "--input"}, title="OpenAPI specification file", required=true, description="location of the OpenAPI specification file, as URL or file (required)")
    private String specFile;
    @Option(name={"-f", "--format"}, title="document format", required=false, description="format of document, as swagger-ui or asciidoc-html (swagger-ui by default)")
    private String format = "swagger-ui";
    @Option(name={"-o", "--output"}, title="output directory", description="location of the generated document (current dir by default)")
    private String output = "";

    @Override
    public void run() {
        try {
            Path specPath = Paths.get(this.specFile, new String[0]);
            String[] fileName = new String[1];
            DocGenerator docGenerator = (DocGenerator)GeneratorFactory.getGenerator(DocGenerator.class, (String)this.format);
            HashMap<String, Object> docGeneratorConfig = new HashMap<String, Object>();
            if (Files.isDirectory(specPath, new LinkOption[0])) {
                Files.walkFileTree(specPath, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
            } else if (Files.isRegularFile(specPath, new LinkOption[0])) {
                fileName[0] = specPath.toFile().getName();
                docGeneratorConfig.put("contractContent", this.parseOpenApi(specPath));
                docGeneratorConfig.put("outputPath", this.output + File.separator + new File(this.specFile).getName().substring(0, new File(this.specFile).getName().indexOf(".")));
                docGenerator.configure(docGeneratorConfig);
                docGenerator.generate();
            } else {
                fileName[0] = this.specFile;
                docGeneratorConfig.put("contractContent", this.parseOpenApi(specPath));
                docGeneratorConfig.put("outputPath", this.output + File.separator + new File(this.specFile).getName().substring(0, new File(this.specFile).getName().indexOf(".")));
                docGenerator.configure(docGeneratorConfig);
                docGenerator.generate();
            }
            LOGGER.info("Success to generate document, the directory is: {}", (Object)this.output);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
    }

    public OpenAPI parseOpenApi(Path file) {
        SwaggerParseResult swaggerParseResult = new OpenAPIParser().readLocation(file.toString(), null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        return openAPI;
    }

    static /* synthetic */ String access$000(DocGenerate x0) {
        return x0.output;
    }
}

