/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.postgis;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.GeometryTypeEncoding;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.postgis.RasterReader;

final class ExtendedInfo
extends InfoStatements {
    private PreparedStatement geographyColumns;
    private PreparedStatement rasterColumns;
    private RasterReader rasterReader;

    ExtendedInfo(Database<?> session, Connection connection) {
        super(session, connection);
    }

    @Override
    public void completeIntrospection(Analyzer analyzer, TableReference source, Map<String, Column> columns) throws Exception {
        if (!this.isAnalysisPrepared) {
            this.isAnalysisPrepared = true;
            this.geometryColumns = this.prepareIntrospectionStatement(analyzer, "geometry_columns", false, "f_geometry_column", "type");
            this.geographyColumns = this.prepareIntrospectionStatement(analyzer, "geography_columns", false, "f_geography_column", "type");
            this.rasterColumns = this.prepareIntrospectionStatement(analyzer, "raster_columns", true, "r_raster_column", "");
        }
        this.configureSpatialColumns(this.geometryColumns, source, columns, GeometryTypeEncoding.TEXTUAL);
        this.configureSpatialColumns(this.geographyColumns, source, columns, GeometryTypeEncoding.TEXTUAL);
        this.configureSpatialColumns(this.rasterColumns, source, columns, null);
    }

    final RasterReader getRasterReader() {
        if (this.rasterReader == null) {
            this.rasterReader = new RasterReader(this);
        }
        return this.rasterReader;
    }

    @Override
    public void close() throws SQLException {
        if (this.geographyColumns != null) {
            this.geographyColumns.close();
            this.geographyColumns = null;
        }
        if (this.rasterColumns != null) {
            this.rasterColumns.close();
            this.rasterColumns = null;
        }
        super.close();
    }
}

