/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnformattableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.system.Environment;
import org.apache.sis.util.Printable;
import org.apache.sis.util.internal.shared.X364;

@XmlTransient
public abstract class FormattableObject
implements Printable {
    private static final AtomicReference<Formatter> FORMATTER = new AtomicReference();

    protected FormattableObject() {
    }

    public String toWKT() throws UnformattableObjectException {
        return this.formatWKT(Convention.DEFAULT, false, true);
    }

    public String toString() {
        return this.formatWKT(Convention.WKT2_SIMPLIFIED, false, false);
    }

    public String toString(Convention convention) {
        return this.formatWKT(Objects.requireNonNull(convention), false, false);
    }

    public void print() {
        Console console = System.console();
        PrintWriter out = Environment.writer((Console)console, (PrintStream)System.out);
        out.println(this.formatWKT(Convention.WKT2_SIMPLIFIED, console != null && X364.isAnsiSupported(), false));
        out.flush();
    }

    private String formatWKT(Convention convention, boolean colorize, boolean strict) throws UnformattableObjectException {
        String wkt;
        Formatter formatter = FORMATTER.getAndSet(null);
        if (formatter == null) {
            formatter = new Formatter();
        }
        formatter.configure(convention, null, colorize ? Colors.DEFAULT : null, convention.toUpperCase ? (byte)1 : 0, convention.majorVersion() == 1 ? (byte)-1 : 0, (byte)2, strict ? Integer.MAX_VALUE : 10);
        if (!strict) {
            formatter.transliterator = Transliterator.IDENTITY;
        }
        formatter.verifyCharacterValidity = strict;
        try {
            formatter.append(this);
            Warnings warnings = formatter.getWarnings();
            if (warnings != null) {
                if (warnings.getRootElement() == null) {
                    warnings.setRoot(this);
                }
                if (strict) {
                    int n = warnings.getNumMessages() - 1;
                    throw new UnformattableObjectException(warnings.getMessage(n), warnings.getException(n));
                }
            }
            formatter.appendWarnings();
            wkt = formatter.toWKT();
        }
        catch (IOException e) {
            throw new UnformattableObjectException(e);
        }
        finally {
            formatter.clear();
        }
        FORMATTER.set(formatter);
        return wkt;
    }

    protected abstract String formatTo(Formatter var1);
}

