/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.gridded;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.referencing.operation.gridded.GridFile;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class GridLoader {
    public static final double DEGREES_TO_SECONDS = 3600.0;
    protected static final double SECOND_PRECISION = 1.0E-4;
    protected final GridFile file;
    private final ReadableByteChannel channel;
    protected final ByteBuffer buffer;

    protected GridLoader(ReadableByteChannel channel, ByteBuffer buffer, GridFile file) throws IOException {
        this.file = file;
        this.buffer = buffer;
        this.channel = channel;
        channel.read(buffer);
        buffer.flip();
    }

    protected final void ensureBufferContains(int n) throws IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int c;
            this.buffer.compact();
            do {
                if ((c = this.channel.read(this.buffer)) > 0) continue;
                if (c != 0) {
                    throw new EOFException(Errors.format((short)168, (Object)this.file));
                }
                throw new IOException(Errors.format((short)19, (Object)this.file));
            } while ((n -= c) > 0);
            this.buffer.flip();
        }
    }

    protected final void skip(int n) throws IOException {
        int p;
        while ((p = this.buffer.position() + n) > this.buffer.limit()) {
            this.buffer.clear();
            this.ensureBufferContains(Math.min(n -= this.buffer.remaining(), this.buffer.capacity()));
        }
        this.buffer.position(p);
    }

    protected static void log(Class<?> caller, LogRecord record) {
        Logging.completeAndLog((Logger)AbstractProvider.LOGGER, caller, (String)"createMathTransform", (LogRecord)record);
    }
}

