/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.time.Instant;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.converter.DateConverter;
import org.apache.sis.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;

abstract class InstantConverter<T>
extends SystemConverter<Instant, T> {
    private static final long serialVersionUID = -7219681557586687605L;

    InstantConverter(Class<T> targetClass) {
        super(Instant.class, targetClass);
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.SURJECTIVE, FunctionProperty.ORDER_PRESERVING, FunctionProperty.INVERTIBLE);
    }

    public static final class Date
    extends InstantConverter<java.util.Date> {
        private static final long serialVersionUID = -9192665378798185400L;
        static final Date INSTANCE = new Date();

        public static Date provider() {
            return INSTANCE;
        }

        public Date() {
            super(java.util.Date.class);
        }

        @Override
        public ObjectConverter<java.util.Date, Instant> inverse() {
            return DateConverter.Instant.INSTANCE;
        }

        @Override
        public java.util.Date apply(Instant source) {
            return source != null ? java.util.Date.from(source) : null;
        }
    }
}

