/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.modifier;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.metadata.Metadata;
import org.opengis.util.GenericName;

public interface CoverageModifier {
    public static CoverageModifier getOrDefault(StorageConnector connector) {
        CoverageModifier customizer = connector.getOption(DataOptionKey.COVERAGE_MODIFIER);
        return customizer != null ? customizer : Source.DEFAULT;
    }

    default public GenericName customize(Source source, GenericName identifier) throws DataStoreException {
        return identifier;
    }

    default public Metadata customize(Source source, DefaultMetadata metadata) throws DataStoreException {
        metadata.transitionTo(ModifiableMetadata.State.FINAL);
        return metadata;
    }

    default public GridGeometry customize(Source source, GridGeometry domain) throws DataStoreException {
        return domain;
    }

    default public SampleDimension customize(BandSource source, SampleDimension.Builder dimension) throws DataStoreException {
        return dimension.build();
    }

    default public boolean isElectromagneticMeasurement(Source source) throws DataStoreException {
        return false;
    }

    public static class Source {
        static final CoverageModifier DEFAULT = new CoverageModifier(){};
        private final DataStore store;
        private final int coverageIndex;
        private final DataType dataType;

        public Source(DataStore store) {
            this.store = Objects.requireNonNull(store);
            this.coverageIndex = -1;
            this.dataType = null;
        }

        public Source(DataStore store, int coverageIndex, DataType dataType) {
            this.store = Objects.requireNonNull(store);
            this.coverageIndex = coverageIndex;
            this.dataType = dataType;
        }

        public DataStore getDataStore() {
            return this.store;
        }

        public OptionalInt getCoverageIndex() {
            return this.coverageIndex >= 0 ? OptionalInt.of(this.coverageIndex) : OptionalInt.empty();
        }

        public Optional<DataType> getDataType() {
            return Optional.ofNullable(this.dataType);
        }

        int getBandIndex() {
            return -1;
        }

        int getNumBands() {
            return -1;
        }

        Optional<NumberRange<?>> getSampleRange() {
            return Optional.empty();
        }

        public String toString() {
            int coverageIndex = this.getCoverageIndex().orElse(-1);
            int bandIndex = this.getBandIndex();
            int numBands = this.getNumBands();
            return Strings.toString(this.getClass(), (Object[])new Object[]{"store", this.getDataStore().getDisplayName(), "coverageIndex", coverageIndex >= 0 ? Integer.valueOf(coverageIndex) : null, "bandIndex", bandIndex >= 0 ? Integer.valueOf(bandIndex) : null, "numBands", numBands >= 0 ? Integer.valueOf(numBands) : null, "dataType", this.getDataType(), "sampleRange", this.getSampleRange().orElse(null)});
        }
    }

    public static class BandSource
    extends Source {
        private final int bandIndex;
        private final int numBands;

        public BandSource(DataStore store, int coverageIndex, int bandIndex, int numBands, DataType dataType) {
            super(store, coverageIndex, dataType);
            this.bandIndex = bandIndex;
            this.numBands = numBands;
        }

        @Override
        public int getBandIndex() {
            return this.bandIndex;
        }

        @Override
        public int getNumBands() {
            return this.numBands;
        }

        @Override
        public Optional<NumberRange<?>> getSampleRange() {
            return Optional.empty();
        }
    }
}

