/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.Optional;
import org.apache.sis.pending.geoapi.temporal.IndeterminateValue;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.pending.geoapi.temporal.TemporalOperatorName;
import org.apache.sis.temporal.TimeMethods;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.shared.Strings;

abstract class TemporalOperation<T>
implements Serializable {
    private static final long serialVersionUID = -5304814915639460679L;
    private static final WeakHashSet<TemporalOperation<?>> POOL = new WeakHashSet(TemporalOperation.class);
    protected final TimeMethods<T> comparators;

    protected TemporalOperation(TimeMethods<T> comparators) {
        this.comparators = comparators;
    }

    public final TemporalOperation<T> unique() {
        return (TemporalOperation)POOL.unique((Object)this);
    }

    public final int hashCode() {
        return this.getClass().hashCode() + 31 * this.comparators.type.hashCode();
    }

    public final boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((TemporalOperation)other).comparators.type == this.comparators.type;
    }

    public final String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"operator", this.getOperatorType().identifier(), "type", this.comparators.type.getSimpleName()});
    }

    public abstract TemporalOperatorName getOperatorType();

    protected char symbol() {
        return '\u0000';
    }

    protected boolean evaluate(T self, T other) {
        return false;
    }

    protected boolean evaluate(T self, Period other) {
        return false;
    }

    protected boolean evaluate(Period self, T other) {
        return false;
    }

    protected abstract boolean evaluate(Period var1, Period var2);

    protected final boolean compare(TimeMethods.Test test, T self, Instant other) {
        if (other != null) {
            Temporal position;
            Optional p = other.getIndeterminatePosition();
            if (p.isPresent()) {
                IndeterminateValue v = (IndeterminateValue)p.get();
                if (v == IndeterminateValue.NOW) {
                    position = this.comparators.now();
                } else {
                    switch (test) {
                        case BEFORE: {
                            if (v == IndeterminateValue.AFTER) break;
                            return false;
                        }
                        case AFTER: {
                            if (v == IndeterminateValue.BEFORE) break;
                            return false;
                        }
                        case NOT_BEFORE: {
                            if (v != IndeterminateValue.BEFORE) break;
                            return false;
                        }
                        case NOT_AFTER: {
                            if (v != IndeterminateValue.AFTER) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    position = other.getPosition();
                }
            } else {
                position = other.getPosition();
            }
            if (position != null) {
                return this.comparators.convertAndCompare(test, self, (Object)position);
            }
        }
        return false;
    }

    protected static boolean compare(TimeMethods.Test test, Instant self, Instant other) {
        if (self == null || other == null) {
            return false;
        }
        IndeterminateValue p1 = self.getIndeterminatePosition().orElse(null);
        IndeterminateValue p2 = other.getIndeterminatePosition().orElse(null);
        if (p1 != null || p2 != null) {
            IndeterminateValue a2;
            IndeterminateValue a1;
            switch (test) {
                case BEFORE: 
                case NOT_AFTER: {
                    a1 = IndeterminateValue.BEFORE;
                    a2 = IndeterminateValue.AFTER;
                    break;
                }
                case AFTER: 
                case NOT_BEFORE: {
                    a1 = IndeterminateValue.AFTER;
                    a2 = IndeterminateValue.BEFORE;
                    break;
                }
                case EQUAL: {
                    return p1 == p2 && p1 == IndeterminateValue.NOW;
                }
                default: {
                    return false;
                }
            }
            if (TemporalOperation.isAmbiguous(p1, a1) || TemporalOperation.isAmbiguous(p2, a2)) {
                return false;
            }
        }
        return TimeMethods.compareLenient((TimeMethods.Test)test, (Temporal)self.getPosition(), (Temporal)other.getPosition());
    }

    private static boolean isAmbiguous(IndeterminateValue p1, IndeterminateValue required) {
        return p1 != null && p1 != IndeterminateValue.NOW && p1 != required;
    }

    static final class AnyInteracts<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 5972351564286442392L;

        AnyInteracts(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ANY_INTERACTS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            Instant otherBegin;
            Instant selfEnd;
            Instant otherEnd;
            Instant selfBegin = self.getBeginning();
            return selfBegin != null && (otherEnd = other.getEnding()) != null && AnyInteracts.compare(TimeMethods.Test.BEFORE, selfBegin, otherEnd) && (selfEnd = self.getEnding()) != null && (otherBegin = other.getBeginning()) != null && AnyInteracts.compare(TimeMethods.Test.AFTER, selfEnd, otherBegin);
        }
    }

    static final class OverlappedBy<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 2228673820507226463L;

        OverlappedBy(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.OVERLAPPED_BY;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            Instant selfEnd;
            Instant otherEnd;
            Instant otherBegin;
            Instant selfBegin = self.getBeginning();
            return selfBegin != null && (otherBegin = other.getBeginning()) != null && OverlappedBy.compare(TimeMethods.Test.AFTER, selfBegin, otherBegin) && (otherEnd = other.getEnding()) != null && OverlappedBy.compare(TimeMethods.Test.BEFORE, selfBegin, otherEnd) && (selfEnd = self.getEnding()) != null && OverlappedBy.compare(TimeMethods.Test.AFTER, selfEnd, otherEnd);
        }
    }

    static final class Overlaps<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 1517443045593389773L;

        Overlaps(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.OVERLAPS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            Instant otherEnd;
            Instant selfEnd;
            Instant selfBegin;
            Instant otherBegin = other.getBeginning();
            return otherBegin != null && (selfBegin = self.getBeginning()) != null && Overlaps.compare(TimeMethods.Test.BEFORE, selfBegin, otherBegin) && (selfEnd = self.getEnding()) != null && Overlaps.compare(TimeMethods.Test.AFTER, selfEnd, otherBegin) && (otherEnd = other.getEnding()) != null && Overlaps.compare(TimeMethods.Test.BEFORE, selfEnd, otherEnd);
        }
    }

    static final class Contains<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 9107531246948034411L;

        Contains(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.CONTAINS;
        }

        @Override
        protected char symbol() {
            return '\u228b';
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(TimeMethods.Test.AFTER, other, self.getBeginning()) && this.compare(TimeMethods.Test.BEFORE, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Contains.compare(TimeMethods.Test.BEFORE, self.getBeginning(), other.getBeginning()) && Contains.compare(TimeMethods.Test.AFTER, self.getEnding(), other.getEnding());
        }
    }

    static final class During<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -4674319635076886196L;

        During(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.DURING;
        }

        @Override
        protected char symbol() {
            return '\u228a';
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return During.compare(TimeMethods.Test.AFTER, self.getBeginning(), other.getBeginning()) && During.compare(TimeMethods.Test.BEFORE, self.getEnding(), other.getEnding());
        }
    }

    static final class MetBy<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 5358059498707330482L;

        MetBy(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.MET_BY;
        }

        @Override
        public boolean evaluate(T self, T other) {
            return this.comparators.isEqual.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(TimeMethods.Test.EQUAL, self, other.getEnding());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(TimeMethods.Test.EQUAL, other, self.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return MetBy.compare(TimeMethods.Test.EQUAL, self.getBeginning(), other.getEnding());
        }
    }

    static final class Meets<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -3534843269384858443L;

        Meets(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.MEETS;
        }

        @Override
        public boolean evaluate(T self, T other) {
            return this.comparators.isEqual.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(TimeMethods.Test.EQUAL, self, other.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(TimeMethods.Test.EQUAL, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Meets.compare(TimeMethods.Test.EQUAL, self.getEnding(), other.getBeginning());
        }
    }

    static final class EndedBy<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 8586566103462153666L;

        EndedBy(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ENDED_BY;
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(TimeMethods.Test.EQUAL, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return EndedBy.compare(TimeMethods.Test.EQUAL, self.getEnding(), other.getEnding()) && EndedBy.compare(TimeMethods.Test.BEFORE, self.getBeginning(), other.getBeginning());
        }
    }

    static final class BegunBy<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -7212413827394364384L;

        BegunBy(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEGUN_BY;
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(TimeMethods.Test.EQUAL, other, self.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return BegunBy.compare(TimeMethods.Test.EQUAL, self.getBeginning(), other.getBeginning()) && BegunBy.compare(TimeMethods.Test.AFTER, self.getEnding(), other.getEnding());
        }
    }

    static final class Ends<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -5508229966320563437L;

        Ends(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ENDS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Ends.compare(TimeMethods.Test.EQUAL, self.getEnding(), other.getEnding()) && Ends.compare(TimeMethods.Test.AFTER, self.getBeginning(), other.getBeginning());
        }
    }

    static final class Begins<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -7880699329127762233L;

        Begins(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEGINS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Begins.compare(TimeMethods.Test.EQUAL, self.getBeginning(), other.getBeginning()) && Begins.compare(TimeMethods.Test.BEFORE, self.getEnding(), other.getEnding());
        }
    }

    static final class After<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 5410476260417497682L;

        After(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.AFTER;
        }

        @Override
        protected char symbol() {
            return '>';
        }

        @Override
        protected boolean evaluate(T self, T other) {
            return this.comparators.isAfter.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(TimeMethods.Test.AFTER, self, other.getEnding());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(TimeMethods.Test.BEFORE, other, self.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return After.compare(TimeMethods.Test.AFTER, self.getBeginning(), other.getEnding());
        }
    }

    static final class Before<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -3422629447456003982L;

        Before(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEFORE;
        }

        @Override
        protected char symbol() {
            return '<';
        }

        @Override
        protected boolean evaluate(T self, T other) {
            return this.comparators.isBefore.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(TimeMethods.Test.BEFORE, self, other.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(TimeMethods.Test.AFTER, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Before.compare(TimeMethods.Test.BEFORE, self.getEnding(), other.getBeginning());
        }
    }

    static final class Equals<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -6060822291802339424L;

        Equals(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.EQUALS;
        }

        @Override
        protected char symbol() {
            return '=';
        }

        @Override
        protected boolean evaluate(T self, T other) {
            return this.comparators.isEqual.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(TimeMethods.Test.EQUAL, self, other.getBeginning()) && this.compare(TimeMethods.Test.EQUAL, self, other.getEnding());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(TimeMethods.Test.EQUAL, other, self.getBeginning()) && this.compare(TimeMethods.Test.EQUAL, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Equals.compare(TimeMethods.Test.EQUAL, self.getBeginning(), other.getBeginning()) && Equals.compare(TimeMethods.Test.EQUAL, self.getEnding(), other.getEnding());
        }
    }

    @FunctionalInterface
    static interface Factory {
        public <T> TemporalOperation<T> create(TimeMethods<T> var1);
    }
}

