/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.storage;

import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.bgservlets.ExecutionEngine;
import org.apache.sling.bgservlets.JobProgressInfo;
import org.apache.sling.bgservlets.JobStatus;
import org.apache.sling.bgservlets.impl.storage.JobDataImpl;
import org.apache.sling.bgservlets.impl.storage.NodeJobStatusFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class NodeJobStatusFactoryImpl
implements NodeJobStatusFactory {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ExecutionEngine executionEngine;

    @Override
    public JobStatus getJobStatus(Node n) throws RepositoryException {
        return new NodeJobStatus(n);
    }

    protected void bindExecutionEngine(ExecutionEngine executionEngine) {
        this.executionEngine = executionEngine;
    }

    protected void unbindExecutionEngine(ExecutionEngine executionEngine) {
        if (this.executionEngine == executionEngine) {
            this.executionEngine = null;
        }
    }

    private class NodeJobStatus
    implements JobStatus {
        private final String path;
        private final String streamPath;
        private final Date creationTime;

        public NodeJobStatus(Node n) throws RepositoryException {
            this.path = n.getPath();
            this.streamPath = n.hasProperty("sling:jobExtension") ? this.path + "/stream" + "." + n.getProperty("sling:jobExtension").getString() : this.path + "/stream";
            this.creationTime = new JobDataImpl(n).getCreationTime();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getStreamPath() {
            return this.streamPath;
        }

        @Override
        public Date getCreationTime() {
            return this.creationTime;
        }

        @Override
        public JobStatus.State getState() {
            JobStatus j = this.getActiveJob();
            if (j == null) {
                NodeJobStatusFactoryImpl.this.log.debug("Job {} not found by getActiveJob, assuming status==DONE", (Object)this.path);
                return JobStatus.State.DONE;
            }
            return j.getState();
        }

        @Override
        public void requestStateChange(JobStatus.State s) {
            JobStatus j = this.getActiveJob();
            if (j == null) {
                NodeJobStatusFactoryImpl.this.log.debug("Job {} is not active, cannot change state", (Object)this.path);
            } else {
                j.requestStateChange(s);
            }
        }

        @Override
        public JobStatus.State[] getAllowedHumanStateChanges() {
            JobStatus j = this.getActiveJob();
            if (j == null) {
                return new JobStatus.State[0];
            }
            return j.getAllowedHumanStateChanges();
        }

        private JobStatus getActiveJob() {
            if (NodeJobStatusFactoryImpl.this.executionEngine != null) {
                return NodeJobStatusFactoryImpl.this.executionEngine.getJobStatus(this.path);
            }
            return null;
        }

        @Override
        public JobProgressInfo getProgressInfo() {
            JobStatus active = this.getActiveJob();
            if (active != null) {
                return active.getProgressInfo();
            }
            return new JobProgressInfo(){

                @Override
                public String getProgressMessage() {
                    return NodeJobStatus.this.getState().toString();
                }

                @Override
                public Date getEstimatedCompletionTime() {
                    return null;
                }
            };
        }
    }
}

