/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.jobs;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.cms.ConfigurableJobExecutor;
import org.apache.sling.cms.File;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobExecutor.class, ConfigurableJobExecutor.class}, property={"job.topics=cmsjob/org/apache/sling/cms/file/OptimizeFiles"})
public class OptimizeFilesJob
extends ConfigurableJobExecutor {
    public static final Logger log = LoggerFactory.getLogger(OptimizeFilesJob.class);
    public static final String TOPIC = "cmsjob/org/apache/sling/cms/file/OptimizeFiles";
    @Reference
    private FileOptimizerService optimizer;
    @Reference
    private ResourceResolverFactory factory;

    private void collectFiles(Resource root, List<File> files) {
        for (Resource child : root.getChildren()) {
            if ("sling:File".equals(child.getResourceType())) {
                files.add((File)child.adaptTo(File.class));
                continue;
            }
            this.collectFiles(child, files);
        }
    }

    public JobExecutionResult doProcess(Job job, JobExecutionContext context, ResourceResolver resolver) {
        String path = (String)job.getProperty("path", (Object)"");
        Resource root = resolver.getResource(path);
        if (root != null) {
            ArrayList<File> files = new ArrayList<File>();
            if ("sling:File".equals(root.getResourceType())) {
                files.add((File)root.adaptTo(File.class));
            } else {
                this.collectFiles(root, files);
            }
            context.log("Found {0} files to optimize", new Object[]{files.size()});
            context.initProgress(files.size(), -1L);
            int processed = 1;
            for (File file : files) {
                try {
                    if (this.optimizer.canOptimize(file.getResource())) {
                        this.optimizer.optimizeFile(file.getContentResource(), true);
                    }
                    context.incrementProgressCount(processed++);
                    context.log("Optimized file {0}", new Object[]{file.getPath()});
                }
                catch (Throwable t) {
                    context.log("Failed to optimize file {0}", new Object[]{file.getPath()});
                    context.incrementProgressCount(processed++);
                    context.log("Exception {0}", new Object[]{t.getMessage()});
                    log.warn("Failed to extract metadata for " + file.getPath(), t);
                }
            }
            return context.result().message("File(s) optimized").succeeded();
        }
        return context.result().message("No file found at " + path).failed();
    }

    public String getConfigurationPath() {
        return "/mnt/overlay/sling-cms/content/jobs/optimizefiles";
    }

    public ResourceResolverFactory getResolverFactory() {
        return this.factory;
    }

    public String getTitleKey() {
        return "Optimize Files";
    }

    public String getTopic() {
        return TOPIC;
    }
}

