/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.publication;

import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.cms.core.publication.ContentDistributionPublicationManager;
import org.apache.sling.cms.core.publication.PublicationConfig;
import org.apache.sling.cms.core.publication.StandalonePublicationManager;
import org.apache.sling.cms.publication.INSTANCE_TYPE;
import org.apache.sling.cms.publication.PUBLICATION_MODE;
import org.apache.sling.cms.publication.PublicationManager;
import org.apache.sling.cms.publication.PublicationManagerFactory;
import org.apache.sling.distribution.Distributor;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.annotations.Designate;

@Component(service={PublicationManagerFactory.class, AdapterFactory.class}, property={"adaptables=org.apache.sling.api.SlingHttpServletRequest", "adaptables=org.apache.sling.api.resource.ResourceResolver", "adapters=org.apache.sling.cms.publication.PublicationManager"})
@Designate(ocd=PublicationConfig.class)
public class PublicationManagerFactoryImpl
implements PublicationManagerFactory,
AdapterFactory {
    @Reference
    private EventAdmin eventAdmin;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private Distributor distributor;
    private INSTANCE_TYPE instanceType;
    private PUBLICATION_MODE publicationMode;
    private String[] agents;

    @Activate
    public void activate(PublicationConfig config) {
        this.instanceType = config.instanceType();
        this.publicationMode = config.publicationMode();
        this.agents = config.agents();
    }

    public INSTANCE_TYPE getInstanceType() {
        return this.instanceType;
    }

    public PUBLICATION_MODE getPublicationMode() {
        return this.publicationMode;
    }

    public PublicationManager getPublicationManager() {
        if (this.publicationMode == PUBLICATION_MODE.STANDALONE) {
            return new StandalonePublicationManager(this.eventAdmin);
        }
        if (this.distributor != null) {
            return new ContentDistributionPublicationManager(this.distributor, this.agents, this.eventAdmin);
        }
        throw new ComponentException("Sling Content Distribution not found on this instance");
    }

    public <T> T getAdapter(Object adaptable, Class<T> type) {
        return type.cast(this.getPublicationManager());
    }
}

