/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.kafka;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="Apache Sling Journal Distribution - Kafka endpoint", description="Apache Kafka Endpoint. Default values match Kafka properties defaults.")
public @interface KafkaEndpoint {
    @AttributeDefinition(name="Kafka Bootstrap Servers", description="A comma separated list of host/port pairs to use for establishing the initial connection to the Kafka cluster.")
    public String kafkaBootstrapServers() default "localhost:9092";

    @AttributeDefinition(name="Kafka Request Timeout", description="Kafka Request Timeout in ms.")
    public int kafkaRequestTimeout() default 32000;

    @AttributeDefinition(name="Kafka Default API Timeout", description="Kafka Default API Timeout in ms.")
    public int kafkaDefaultApiTimeout() default 60000;

    @AttributeDefinition(name="Kafka Security protocol", description="Kafka Protocol used to communicate with brokers.")
    public String securityProtocol() default "PLAINTEXT";

    @AttributeDefinition(name="Kafka SASL mechanism", description="Kafka SASL mechanism used for client connections.")
    public String saslMechanism() default "GSSAPI";

    @AttributeDefinition(name="Kafka SASL JAAS config", description="Kafka JAAS login context parameters for SASL connections in the format used by JAAS configuration files.")
    public String saslJaasConfig();
}

