/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;

public class BuilderContext {
    public static final String VERSION_OVERRIDE_ALL = "ALL";
    public static final String VERSION_OVERRIDE_HIGHEST = "HIGHEST";
    public static final String VERSION_OVERRIDE_LATEST = "LATEST";
    public static final String COORDINATE_MATCH_ALL = "*";
    public static final String CONFIG_FAIL_ON_CLASH = "CLASH";
    public static final String CONFIG_FAIL_ON_PROPERTY_CLASH = "PROPERTY_CLASH";
    public static final String CONFIG_USE_LATEST = "USE_LATEST";
    public static final String CONFIG_USE_FIRST = "USE_FIRST";
    public static final String CONFIG_MERGE_LATEST = "MERGE_LATEST";
    public static final String CONFIG_MERGE_FIRST = "MERGE_FIRST";
    static final String CONFIGURATION_ALL_HANDLERS_KEY = "all";
    private final FeatureProvider provider;
    private ArtifactProvider artifactProvider;
    private final Map<String, Map<String, String>> extensionConfiguration = new HashMap<String, Map<String, String>>();
    private final List<MergeHandler> mergeExtensions = new ArrayList<MergeHandler>();
    private final List<PostProcessHandler> postProcessExtensions = new ArrayList<PostProcessHandler>();
    private final List<ArtifactId> artifactsOverrides = new ArrayList<ArtifactId>();
    private final Map<String, String> variables = new HashMap<String, String>();
    private final Map<String, String> frameworkProperties = new HashMap<String, String>();
    private final Map<String, String> configOverrides = new LinkedHashMap<String, String>();

    public BuilderContext(FeatureProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null");
        }
        this.provider = provider;
    }

    public BuilderContext setArtifactProvider(ArtifactProvider ap) {
        this.artifactProvider = ap;
        return this;
    }

    public BuilderContext addVariablesOverrides(Map<String, String> vars) {
        this.variables.putAll(vars);
        return this;
    }

    public BuilderContext addFrameworkPropertiesOverrides(Map<String, String> props) {
        this.frameworkProperties.putAll(props);
        return this;
    }

    @Deprecated
    public BuilderContext addArtifactsOverrides(List<String> overrides) {
        this.artifactsOverrides.addAll(overrides.stream().map(f -> ArtifactId.parse(f)).collect(Collectors.toList()));
        return this;
    }

    public BuilderContext addArtifactsOverride(ArtifactId override) {
        this.artifactsOverrides.add(override);
        return this;
    }

    public BuilderContext addConfigsOverrides(Map<String, String> overrides) {
        this.configOverrides.putAll(overrides);
        return this;
    }

    public BuilderContext addMergeExtensions(MergeHandler ... extensions) {
        this.mergeExtensions.addAll(Arrays.asList(extensions));
        return this;
    }

    public BuilderContext addPostProcessExtensions(PostProcessHandler ... extensions) {
        this.postProcessExtensions.addAll(Arrays.asList(extensions));
        return this;
    }

    public BuilderContext setHandlerConfiguration(String name, Map<String, String> cfg) {
        this.extensionConfiguration.put(name, cfg);
        return this;
    }

    Map<String, Map<String, String>> getHandlerConfigurations() {
        return this.extensionConfiguration;
    }

    ArtifactProvider getArtifactProvider() {
        return this.artifactProvider;
    }

    List<ArtifactId> getArtifactOverrides() {
        return this.artifactsOverrides;
    }

    Map<String, String> getConfigOverrides() {
        return this.configOverrides;
    }

    Map<String, String> getVariablesOverrides() {
        return this.variables;
    }

    Map<String, String> getFrameworkPropertiesOverrides() {
        return this.frameworkProperties;
    }

    FeatureProvider getFeatureProvider() {
        return this.provider;
    }

    List<MergeHandler> getMergeExtensions() {
        return this.mergeExtensions;
    }

    List<PostProcessHandler> getPostProcessExtensions() {
        return this.postProcessExtensions;
    }

    BuilderContext clone(FeatureProvider featureProvider) {
        BuilderContext ctx = new BuilderContext(featureProvider);
        ctx.setArtifactProvider(this.artifactProvider);
        ctx.artifactsOverrides.addAll(this.artifactsOverrides);
        ctx.variables.putAll(this.variables);
        ctx.frameworkProperties.putAll(this.frameworkProperties);
        ctx.extensionConfiguration.putAll(this.extensionConfiguration);
        ctx.mergeExtensions.addAll(this.mergeExtensions);
        ctx.postProcessExtensions.addAll(this.postProcessExtensions);
        return ctx;
    }
}

