/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.maintenance.internal;

import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.sling.jcr.maintenance.DataStoreCleanupConfig;
import org.apache.sling.jcr.maintenance.RepositoryManagementUtil;
import org.apache.sling.jcr.maintenance.RunnableJob;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Runnable.class}, property={"scheduler.concurrent:Boolean=false"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=DataStoreCleanupConfig.class)
public class DataStoreCleanupScheduler
implements RunnableJob {
    private static final Logger log = LoggerFactory.getLogger(DataStoreCleanupScheduler.class);
    private final RepositoryManagementMBean repositoryManager;
    private final String schedulerExpression;

    @Activate
    public DataStoreCleanupScheduler(DataStoreCleanupConfig config, @Reference RepositoryManagementMBean repositoryManager) {
        this.repositoryManager = repositoryManager;
        this.schedulerExpression = config.scheduler_expression();
    }

    @Override
    public void run() {
        if (!RepositoryManagementUtil.isRunning(this.repositoryManager.getDataStoreGCStatus())) {
            log.info("Starting DataStore Garbage Collection");
            this.repositoryManager.startDataStoreGC(false);
        } else {
            log.warn("DataStore Garbage Collection already running!");
        }
    }

    @Override
    public String getSchedulerExpression() {
        return this.schedulerExpression;
    }
}

