/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.Closeable;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.external.URIProvider;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrListenerBaseConfig;
import org.apache.sling.jcr.resource.internal.JcrModifiableValueMap;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.helper.jcr.BasicQueryLanguageProvider;
import org.apache.sling.jcr.resource.internal.helper.jcr.ContextUtil;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderState;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderStateFactory;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Adaptable(adaptableClass=ResourceProvider.class, adapters={@Adapter(value={Session.class}, condition="If the JcrResourceProvider is loaded"), @Adapter(value={Principal.class}, condition="If the underlying java.jcr.Session implements JackrabbitSession")})
@Component(name="org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory", service={ResourceProvider.class}, property={"provider.name=JCR", "provider.root=/", "provider.modifiable:Boolean=true", "provider.adaptable:Boolean=true", "provider.attributable:Boolean=true", "provider.refreshable:Boolean=true", "provider.authenticate=required", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=Configuration.class)
public class JcrResourceProvider
extends ResourceProvider<JcrProviderState> {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceProvider.class);
    private static final String REPOSITORY_REFERENCE_NAME = "repository";
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    @Reference(name="repository", service=SlingRepository.class)
    private ServiceReference<SlingRepository> repositoryReference;
    private volatile JcrListenerBaseConfig listenerConfig;
    private final Map<ObserverConfiguration, Closeable> listeners = new HashMap<ObserverConfiguration, Closeable>();
    private final SortedMap<ServiceReference<URIProvider>, URIProvider> providers = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
    private volatile SlingRepository repository;
    private volatile JcrProviderStateFactory stateFactory;
    private final AtomicReference<DynamicClassLoaderManager> classLoaderManagerReference = new AtomicReference();
    private final AtomicReference<URIProvider[]> uriProviderReference = new AtomicReference();
    private static boolean idAddressing;

    @Activate
    protected void activate(ComponentContext context, Configuration configuration) {
        SlingRepository slingRepository = (SlingRepository)context.locateService(REPOSITORY_REFERENCE_NAME, this.repositoryReference);
        if (slingRepository == null) {
            this.logger.warn("activate: Activation failed because SlingRepository may have been unregistered concurrently");
            return;
        }
        this.repository = slingRepository;
        this.stateFactory = new JcrProviderStateFactory(this.repositoryReference, slingRepository, this.classLoaderManagerReference, this.uriProviderReference);
        idAddressing = configuration.resource_addressingById();
    }

    @Deactivate
    protected void deactivate() {
        this.stateFactory = null;
    }

    @Reference(name="dynamicClassLoaderManager", service=DynamicClassLoaderManager.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.classLoaderManagerReference.set(dynamicClassLoaderManager);
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.classLoaderManagerReference.compareAndSet(dynamicClassLoaderManager, null);
    }

    @Reference(name="uriprovider", service=URIProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindUriProvider", unbind="unbindUriProvider")
    private void bindUriProvider(ServiceReference<URIProvider> srUriProvider, URIProvider uriProvider) {
        this.providers.put(srUriProvider, uriProvider);
        this.updateURIProviders();
    }

    private void unbindUriProvider(ServiceReference<URIProvider> srUriProvider) {
        this.providers.remove(srUriProvider);
        this.updateURIProviders();
    }

    private void updateURIProviders() {
        URIProvider[] ups = this.providers.values().toArray(new URIProvider[0]);
        this.uriProviderReference.set(ups);
    }

    public void start(@NotNull ProviderContext ctx) {
        super.start(ctx);
        this.registerListeners();
    }

    public void stop() {
        this.unregisterListeners();
        super.stop();
    }

    public void update(long changeSet) {
        super.update(changeSet);
        this.updateListeners();
    }

    public static boolean isIdAddressingEnabled() {
        return idAddressing;
    }

    private void bindRepository(ServiceReference<SlingRepository> ref) {
        this.repositoryReference = ref;
        this.repository = null;
    }

    private void unbindRepository(ServiceReference<SlingRepository> ref) {
        if (this.repositoryReference == ref) {
            this.repositoryReference = null;
            this.repository = null;
        }
    }

    private void registerListeners() {
        if (this.repository != null) {
            this.logger.debug("Registering resource listeners...");
            try {
                this.listenerConfig = new JcrListenerBaseConfig(this.getProviderContext().getObservationReporter(), this.repository);
                for (ObserverConfiguration config : this.getProviderContext().getObservationReporter().getObserverConfigurations()) {
                    this.logger.debug("Registering listener for {}", (Object)config.getPaths());
                    JcrResourceListener listener = new JcrResourceListener(this.listenerConfig, config);
                    this.listeners.put(config, listener);
                }
            }
            catch (RepositoryException e) {
                throw new SlingException("Can't create the JCR event listener.", (Throwable)e);
            }
            this.logger.debug("Registered resource listeners");
        }
    }

    private void unregisterListeners() {
        this.logger.debug("Unregistering resource listeners...");
        for (Closeable c : this.listeners.values()) {
            try {
                this.logger.debug("Removing listener for {}", (Object)((JcrResourceListener)c).getConfig().getPaths());
                c.close();
            }
            catch (IOException iOException) {}
        }
        this.listeners.clear();
        if (this.listenerConfig != null) {
            this.listenerConfig.close();
            this.listenerConfig = null;
        }
        this.logger.debug("Unregistered resource listeners");
    }

    private void updateListeners() {
        if (this.listenerConfig == null) {
            this.unregisterListeners();
            this.registerListeners();
        } else {
            this.logger.debug("Updating resource listeners...");
            HashMap<ObserverConfiguration, Closeable> oldMap = new HashMap<ObserverConfiguration, Closeable>(this.listeners);
            this.listeners.clear();
            try {
                for (ObserverConfiguration config : this.getProviderContext().getObservationReporter().getObserverConfigurations()) {
                    Closeable listener = (Closeable)oldMap.remove(config);
                    if (listener == null) {
                        this.logger.debug("Registering listener for {}", (Object)config.getPaths());
                        listener = new JcrResourceListener(this.listenerConfig, config);
                    } else {
                        this.logger.debug("Updating listener for {}", (Object)config.getPaths());
                        ((JcrResourceListener)listener).update(config);
                    }
                    this.listeners.put(config, listener);
                }
            }
            catch (RepositoryException e) {
                throw new SlingException("Can't create the JCR event listener.", (Throwable)e);
            }
            for (Closeable c : oldMap.values()) {
                try {
                    this.logger.debug("Removing listener for {}", (Object)((JcrResourceListener)c).getConfig().getPaths());
                    c.close();
                }
                catch (IOException iOException) {}
            }
            this.logger.debug("Updated resource listeners");
        }
    }

    @NotNull
    public JcrProviderState authenticate(@NotNull Map<String, Object> authenticationInfo) throws LoginException {
        return this.stateFactory.createProviderState(authenticationInfo);
    }

    public void logout(@Nullable JcrProviderState state) {
        if (state != null) {
            state.logout();
        }
    }

    public boolean isLive(@NotNull ResolveContext<JcrProviderState> ctx) {
        return ContextUtil.getSession(ctx).isLive();
    }

    @Nullable
    public Resource getResource(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull String path, @NotNull ResourceContext rCtx, @Nullable Resource parent) {
        try {
            return ContextUtil.getResourceFactory(ctx).createResource(ctx.getResourceResolver(), path, parent, rCtx.getResolveParameters());
        }
        catch (RepositoryException e) {
            throw new SlingException("Can't get resource", (Throwable)e);
        }
    }

    @Nullable
    public Iterator<Resource> listChildren(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull Resource parent) {
        JcrItemResource<?> parentItemResource;
        if (parent instanceof JcrItemResource) {
            parentItemResource = (JcrItemResource<?>)parent;
        } else {
            try {
                parentItemResource = ContextUtil.getResourceFactory(ctx).createResource(parent.getResourceResolver(), parent.getPath(), null, parent.getResourceMetadata().getParameterMap());
            }
            catch (RepositoryException re) {
                throw new SlingException("Can't list children", (Throwable)re);
            }
        }
        return parentItemResource != null ? parentItemResource.listJcrChildren() : null;
    }

    @Nullable
    public Resource getParent(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull Resource child) {
        if (child instanceof JcrItemResource) {
            String parentPath;
            String version = null;
            if (child.getResourceMetadata().getParameterMap() != null) {
                version = (String)child.getResourceMetadata().getParameterMap().get("v");
            }
            if (version == null && (parentPath = ResourceUtil.getParent((String)child.getPath())) != null) {
                Object childItem = ((JcrItemResource)child).getItem();
                Node parentNode = ContextUtil.getResourceFactory(ctx).getParentOrNull((Item)childItem, parentPath);
                if (parentNode != null) {
                    return new JcrNodeResource(ctx.getResourceResolver(), parentPath, null, parentNode, ContextUtil.getHelperData(ctx));
                }
            }
            return null;
        }
        return super.getParent(ctx, child);
    }

    @NotNull
    public Collection<String> getAttributeNames(@NotNull ResolveContext<JcrProviderState> ctx) {
        String[] sessionNames;
        HashSet<String> names = new HashSet<String>();
        for (String name : sessionNames = ContextUtil.getSession(ctx).getAttributeNames()) {
            if (!JcrResourceProvider.isAttributeVisible(name)) continue;
            names.add(name);
        }
        return names;
    }

    @Nullable
    public Object getAttribute(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull String name) {
        if (JcrResourceProvider.isAttributeVisible(name)) {
            if ("user.name".equals(name)) {
                return ContextUtil.getSession(ctx).getUserID();
            }
            return ContextUtil.getSession(ctx).getAttribute(name);
        }
        return null;
    }

    @NotNull
    public Resource create(@NotNull ResolveContext<JcrProviderState> ctx, @Nullable String path, @Nullable Map<String, Object> properties) throws PersistenceException {
        if (path == null) {
            throw new PersistenceException("Unable to create node with [path=null]");
        }
        try {
            int lastPos = path.lastIndexOf(47);
            Node parent = lastPos == 0 ? ContextUtil.getSession(ctx).getRootNode() : (Node)ContextUtil.getSession(ctx).getItem(path.substring(0, lastPos));
            String name = path.substring(lastPos + 1);
            String nodeType = JcrResourceProvider.getNodeType(properties, ctx);
            Node node = nodeType != null ? parent.addNode(name, nodeType) : parent.addNode(name);
            if (properties != null) {
                JcrResourceProvider.populateProperties(node, properties, ctx, path);
            }
            return new JcrNodeResource(ctx.getResourceResolver(), path, null, node, ContextUtil.getHelperData(ctx));
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to create node at " + path, (Throwable)e, path, null);
        }
    }

    @Nullable
    protected static String getNodeType(@Nullable Map<String, Object> properties, @NotNull ResolveContext<JcrProviderState> ctx) {
        String resourceType;
        if (properties == null) {
            return null;
        }
        Object primaryTypeObj = properties.get("jcr:primaryType");
        if (primaryTypeObj != null) {
            return primaryTypeObj.toString();
        }
        Object resourceTypeObject = properties.get("sling:resourceType");
        if (resourceTypeObject != null && JcrResourceProvider.looksLikeANodeType(resourceType = resourceTypeObject.toString())) {
            try {
                ContextUtil.getSession(ctx).getWorkspace().getNodeTypeManager().getNodeType(resourceType);
                return resourceType;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean looksLikeANodeType(String resourceType) {
        return resourceType.indexOf(58) != -1 && resourceType.indexOf(47) == -1;
    }

    private static void populateProperties(@NotNull Node node, @NotNull Map<String, Object> properties, @NotNull ResolveContext<JcrProviderState> ctx, @NotNull String path) throws PersistenceException {
        JcrModifiableValueMap jcrMap = new JcrModifiableValueMap(node, ContextUtil.getHelperData(ctx));
        Object value = properties.get("jcr:mixinTypes");
        if (value != null) {
            jcrMap.put("jcr:mixinTypes", value);
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (IGNORED_PROPERTIES.contains(entry.getKey())) continue;
            try {
                jcrMap.put(entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException iae) {
                try {
                    node.remove();
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                throw new PersistenceException(iae.getMessage(), (Throwable)iae, path, entry.getKey());
            }
        }
    }

    public boolean orderBefore(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull Resource parent, @NotNull String name, @Nullable String followingSiblingName) throws PersistenceException {
        Node node = (Node)parent.adaptTo(Node.class);
        if (node == null) {
            throw new PersistenceException("The resource " + parent.getPath() + " cannot be adapted to Node. It is probably not provided by the JcrResourceProvider");
        }
        try {
            if (JcrResourceProvider.requiresReorder(node, name, followingSiblingName)) {
                node.orderBefore(name, followingSiblingName);
                return true;
            }
            return false;
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to reorder children below " + parent.getPath(), (Throwable)e, parent.getPath(), null);
        }
    }

    private static boolean requiresReorder(@NotNull Node node, @NotNull String name, @Nullable String followingSiblingName) throws RepositoryException {
        NodeIterator nodeIterator = node.getNodes();
        long existingNodePosition = -1L;
        long index = 0L;
        while (nodeIterator.hasNext()) {
            Node childNode = nodeIterator.nextNode();
            if (childNode.getName().equals(name)) {
                existingNodePosition = index;
            }
            if (existingNodePosition >= 0L && (childNode.getName().equals(followingSiblingName) ? existingNodePosition == index - 1L : followingSiblingName == null && existingNodePosition == nodeIterator.getSize() - 1L)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public void delete(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull Resource resource) throws PersistenceException {
        Item item = (Item)resource.adaptTo(Item.class);
        try {
            if (item == null) {
                item = ContextUtil.getSession(ctx).getItem(resource.getPath());
            }
            item.remove();
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to delete resource", (Throwable)e, resource.getPath(), null);
        }
    }

    public void revert(@NotNull ResolveContext<JcrProviderState> ctx) {
        try {
            ContextUtil.getSession(ctx).refresh(false);
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to revert pending changes.", (Throwable)ignore);
        }
    }

    public void commit(@NotNull ResolveContext<JcrProviderState> ctx) throws PersistenceException {
        try {
            ContextUtil.getSession(ctx).save();
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to commit changes to session.", (Throwable)e);
        }
    }

    public boolean hasChanges(@NotNull ResolveContext<JcrProviderState> ctx) {
        try {
            return ContextUtil.getSession(ctx).hasPendingChanges();
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to check session for pending changes.", (Throwable)ignore);
            return false;
        }
    }

    public void refresh(@NotNull ResolveContext<JcrProviderState> ctx) {
        try {
            ContextUtil.getSession(ctx).refresh(true);
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to refresh session.", (Throwable)ignore);
        }
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull Class<AdapterType> type) {
        Session session = ContextUtil.getSession(ctx);
        if (type == Session.class) {
            return (AdapterType)session;
        }
        if (type == Principal.class) {
            try {
                Authorizable auth;
                JackrabbitSession s;
                UserManager um;
                if (session instanceof JackrabbitSession && session.getUserID() != null && (um = (s = (JackrabbitSession)session).getUserManager()) != null && (auth = um.getAuthorizable(s.getUserID())) != null) {
                    return (AdapterType)auth.getPrincipal();
                }
                this.logger.debug("not able to adapto Resource to Principal, let the base class try to adapt");
            }
            catch (RepositoryException e) {
                this.logger.warn("error while adapting Resource to Principal, let the base class try to adapt", (Throwable)e);
            }
        }
        return (AdapterType)super.adaptTo(ctx, type);
    }

    public boolean copy(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull String srcAbsPath, @NotNull String destAbsPath) {
        return false;
    }

    public boolean move(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull String srcAbsPath, @NotNull String destAbsPath) throws PersistenceException {
        String srcNodePath = srcAbsPath;
        String dstNodePath = destAbsPath + "/" + ResourceUtil.getName((String)srcAbsPath);
        try {
            ContextUtil.getSession(ctx).move(srcNodePath, dstNodePath);
            return true;
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to move resource to " + destAbsPath, (Throwable)e, srcAbsPath, null);
        }
    }

    @Nullable
    public QueryLanguageProvider<JcrProviderState> getQueryLanguageProvider() {
        ProviderContext ctx = this.getProviderContext();
        if (ctx != null) {
            return new BasicQueryLanguageProvider(ctx);
        }
        return null;
    }

    private static boolean isAttributeVisible(String name) {
        return !name.equals("user.jcr.credentials") && !name.contains("password");
    }

    static {
        IGNORED_PROPERTIES.add("jcr:mixinTypes");
        IGNORED_PROPERTIES.add("jcr:primaryType");
        IGNORED_PROPERTIES.add("jcr:created");
        IGNORED_PROPERTIES.add("jcr:createdBy");
    }

    @ObjectClassDefinition(name="Apache Sling JCR Resource Provider", description="The JCR Resource Provider provides access to the JCR repository.")
    static @interface Configuration {
        @AttributeDefinition(name="Resource Addressing by ID", description="If enabled, the resource provider will enable addressing resources by their JCR UUID by using the special path prefix '/jcr:id/'.")
        public boolean resource_addressingById() default false;
    }

    @Adaptable(adaptableClass=ResourceResolver.class, adapters={@Adapter(value={Session.class}, condition="If the JcrResourceProvider is loaded"), @Adapter(value={Principal.class}, condition="If the underlying java.jcr.Session implements JackrabbitSession")})
    private static final class EmptyAdaptableAnnotationCarryingClass {
        private EmptyAdaptableAnnotationCarryingClass() {
        }
    }
}

