/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resourcesecurity.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resourceaccesssecurity.AllowingResourceAccessGate;
import org.apache.sling.resourceaccesssecurity.ResourceAccessGate;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={ResourceAccessGate.class}, property={"operations=read", "operations=create", "operations=update", "operations=delete", "operations=order-children", "access.context=provider"})
@Designate(factory=true, ocd=Configuration.class)
public class ResourceAccessGateFactory
extends AllowingResourceAccessGate
implements ResourceAccessGate {
    static final String PROP_JCR_PATH = "jcrPath";
    static final String PROP_PREFIX = "checkpath.prefix";
    private String jcrPath;
    private String prefix;
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceAccessGateFactory.class);

    @Activate
    protected void activate(Configuration configuration) {
        this.jcrPath = configuration.jcrPath();
        this.prefix = configuration.checkpath_prefix();
        if (this.prefix != null && !this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
    }

    private ResourceAccessGate.GateResult checkPermission(ResourceResolver resolver, String path, String permission) {
        boolean granted = false;
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session != null) {
            String checkPath = this.jcrPath;
            if (this.prefix != null && path.startsWith(this.prefix)) {
                checkPath = this.jcrPath + path.substring(this.prefix.length() - 1);
            }
            try {
                granted = session.hasPermission(checkPath, permission);
            }
            catch (RepositoryException re) {
                LOGGER.debug("Could not retrieve permission {} for path {}", new Object[]{checkPath, permission, re});
            }
        }
        return granted ? ResourceAccessGate.GateResult.GRANTED : ResourceAccessGate.GateResult.DENIED;
    }

    public boolean hasReadRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public boolean hasCreateRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public boolean hasOrderChildrenRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public boolean hasUpdateRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public boolean hasDeleteRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public ResourceAccessGate.GateResult canRead(Resource resource) {
        return this.checkPermission(resource.getResourceResolver(), resource.getPath(), "read");
    }

    public ResourceAccessGate.GateResult canDelete(Resource resource) {
        return this.checkPermission(resource.getResourceResolver(), resource.getPath(), "remove");
    }

    public ResourceAccessGate.GateResult canUpdate(Resource resource) {
        return this.checkPermission(resource.getResourceResolver(), resource.getPath(), "set_property");
    }

    public ResourceAccessGate.GateResult canCreate(String absPathName, ResourceResolver resourceResolver) {
        return this.checkPermission(resourceResolver, absPathName, "add_node");
    }

    public ResourceAccessGate.GateResult canOrderChildren(Resource resource) {
        return this.checkPermission(resource.getResourceResolver(), resource.getPath(), "set_property");
    }

    @ObjectClassDefinition(name="Apache Sling JCR Resource Access Gate", description="This access gate can be used to handle the access to resources not backed by a JCR repository by leveraging ACLs in the JCR repository")
    public static @interface Configuration {
        @AttributeDefinition(name="Path", description="The path is a regular expression which must match the affected resource path for this service to be called.")
        public String path() default ".*";

        @AttributeDefinition(name="Deep Check Prefix", description="If this value is configured and the resource path starts with this prefix, the prefix is removed from the path and the remaining part is appended  to the JCR path to check. For example if /foo/a/b/c is required, this prefix is  configured with /foo and the JCR node to check is /check, the permissions at  /check/a/b/c are checked.")
        public String checkpath_prefix();

        @AttributeDefinition(name="JCR Node Path", description="The node given through this path is consulted for granting/denying permissions to the resources. If 'Deep Check Prefix' is used, then this only specifies the node's path prefix.")
        public String jcrPath();
    }
}

