/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.jacksonexporter.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.jacksonexporter.ModuleProvider;
import org.apache.sling.models.jacksonexporter.impl.ModelSkippingSerializers;
import org.apache.sling.models.jacksonexporter.impl.ResourceSerializer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ModuleProvider.class})
@Designate(ocd=Config.class)
public class ResourceModuleProvider
implements ModuleProvider {
    private static final int DEFAULT_MAX_RECURSION_LEVELS = -1;
    private SimpleModule moduleInstance;

    @Activate
    private void activate(Config config) {
        int maxRecursionLevels = config.max_recursion_levels();
        this.moduleInstance = new SimpleModule();
        ModelSkippingSerializers serializers = new ModelSkippingSerializers();
        serializers.addSerializer(Resource.class, new ResourceSerializer(maxRecursionLevels));
        this.moduleInstance.setSerializers((SimpleSerializers)serializers);
    }

    @Override
    public Module getModule() {
        return this.moduleInstance;
    }

    @ObjectClassDefinition(name="Apache Sling Models Jackson Exporter - Resource object support", description="Provider of a Jackson Module which enables support for proper serialization of Resource objects")
    static @interface Config {
        @AttributeDefinition(name="Maximum Recursion Levels", description="Maximum number of levels of child resources which will be exported for each resource. Specify -1 for infinite.")
        public int max_recursion_levels() default -1;
    }
}

