/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.selector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sling.query.api.SearchStrategy;
import org.apache.sling.query.api.internal.IteratorToIteratorFunction;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.impl.function.CompositeFunction;
import org.apache.sling.query.impl.function.FilterFunction;
import org.apache.sling.query.impl.iterator.AlternativeIterator;
import org.apache.sling.query.impl.iterator.EmptyElementFilter;
import org.apache.sling.query.impl.iterator.SuppIterator;
import org.apache.sling.query.impl.selector.FunctionType;
import org.apache.sling.query.impl.selector.HierarchyOperator;
import org.apache.sling.query.impl.selector.parser.Modifier;
import org.apache.sling.query.impl.selector.parser.Selector;
import org.apache.sling.query.impl.selector.parser.SelectorParser;
import org.apache.sling.query.impl.selector.parser.SelectorSegment;
import org.apache.sling.query.impl.util.IteratorUtils;
import org.apache.sling.query.impl.util.LazyList;

public class SelectorFunction<T>
implements IteratorToIteratorFunction<T>,
Predicate<T> {
    private final List<IteratorToIteratorFunction<T>> selectorFunctions;
    private final TreeProvider<T> provider;
    private final SearchStrategy strategy;

    public SelectorFunction(String selector, TreeProvider<T> provider, SearchStrategy strategy) {
        this.provider = provider;
        this.strategy = strategy;
        List<Selector> selectors = SelectorParser.parse(selector);
        this.selectorFunctions = new ArrayList<IteratorToIteratorFunction<T>>();
        for (Selector s : selectors) {
            this.selectorFunctions.add(this.createSelectorFunction(s.getSegments()));
        }
    }

    @Override
    public Iterator<Option<T>> apply(Iterator<Option<T>> input) {
        LazyList<Option<T>> list = new LazyList<Option<T>>(input);
        ArrayList iterators = new ArrayList();
        for (IteratorToIteratorFunction<T> function : this.selectorFunctions) {
            iterators.add(new SuppIterator<T>(list, function));
        }
        return new AlternativeIterator(iterators);
    }

    @Override
    public boolean test(T resource) {
        Iterator<Option<T>> result = this.apply(IteratorUtils.singleElementIterator(Option.of(resource, 0)));
        return new EmptyElementFilter<T>(result).hasNext();
    }

    private IteratorToIteratorFunction<T> createSelectorFunction(List<SelectorSegment> segments) {
        ArrayList segmentFunctions = new ArrayList();
        for (SelectorSegment segment : segments) {
            segmentFunctions.addAll(this.createSegmentFunction(segment));
        }
        return new CompositeFunction(segmentFunctions);
    }

    private List<Function<?, ?>> createSegmentFunction(SelectorSegment segment) {
        ArrayList functions = new ArrayList();
        HierarchyOperator operator = HierarchyOperator.findByCharacter(segment.getHierarchyOperator());
        functions.add(operator.getFunction(segment, this.strategy, this.provider));
        Predicate<T> predicate = this.provider.getPredicate(segment.getType(), segment.getName(), segment.getAttributes());
        functions.add(new FilterFunction<T>(predicate));
        for (Modifier modifiers : segment.getModifiers()) {
            FunctionType type = FunctionType.valueOf(modifiers.getName().toUpperCase());
            Function<?, ?> f = type.getFunction(modifiers.getArgument(), this.strategy, this.provider);
            functions.add(f);
        }
        return functions;
    }
}

