/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParentTag
extends TagSupport {
    private static final Logger log = LoggerFactory.getLogger(GetParentTag.class);
    private static final long serialVersionUID = -3419869755342010983L;
    private transient Resource resource;
    private String level;
    private String var;

    public int doEndTag() {
        log.trace("doEndTag");
        Resource parent = null;
        if (this.resource != null) {
            if (this.level != null) {
                String parentPath = ResourceUtil.getParent((String)this.resource.getPath(), (int)Integer.parseInt(this.level, 10));
                log.debug("Retrieving {} parent resource at path {}", (Object)this.level, (Object)parentPath);
                parent = this.resource.getResourceResolver().getResource(parentPath);
            } else {
                log.debug("Retrieving parent resource");
                parent = this.resource.getParent();
            }
        }
        log.debug("Saving {} to variable {}", parent, (Object)this.var);
        this.pageContext.setAttribute(this.var, (Object)parent);
        return 6;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getLevel() {
        return this.level;
    }

    public String getVar() {
        return this.var;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

