/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.render;

import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.sling.scripting.sightly.Record;
import org.apache.sling.scripting.sightly.render.RenderContext;

public abstract class RenderUnit
implements Record<RenderUnit> {
    private final Map<String, RenderUnit> subTemplates = new HashMap<String, RenderUnit>();
    private Map<String, RenderUnit> siblings;

    public final void render(PrintWriter out, RenderContext renderContext, Bindings arguments) {
        Bindings globalBindings = renderContext.getBindings();
        this.render(out, this.buildGlobalScope(globalBindings), new CaseInsensitiveBindings(arguments), renderContext);
    }

    @Override
    public RenderUnit getProperty(String name) {
        return this.subTemplates.get(name.toLowerCase());
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.subTemplates.keySet();
    }

    protected abstract void render(PrintWriter var1, Bindings var2, Bindings var3, RenderContext var4);

    protected void callUnit(PrintWriter out, RenderContext renderContext, Object templateObj, Object argsObj) {
        if (!(templateObj instanceof RenderUnit)) {
            if (templateObj == null) {
                throw new RuntimeException("data-sly-call: expression evaluates to null.");
            }
            if (renderContext.getObjectModel().isPrimitive(templateObj)) {
                throw new RuntimeException("data-sly-call: primitive \"" + templateObj.toString() + "\" does not represent a HTL template.");
            }
            if (templateObj instanceof String) {
                throw new RuntimeException("data-sly-call: String '" + templateObj.toString() + "' does not represent a HTL template.");
            }
            throw new RuntimeException("data-sly-call: " + templateObj.getClass().getName() + " does not represent a HTL template.");
        }
        RenderUnit unit = (RenderUnit)templateObj;
        Map argumentsMap = renderContext.getObjectModel().toMap(argsObj);
        SimpleBindings arguments = new SimpleBindings(Collections.unmodifiableMap(argumentsMap));
        unit.render(out, renderContext, arguments);
    }

    protected FluentMap obj() {
        return new FluentMap();
    }

    protected final void addSubTemplate(String name, RenderUnit renderUnit) {
        renderUnit.setSiblings(this.subTemplates);
        this.subTemplates.put(name.toLowerCase(), renderUnit);
    }

    private void setSiblings(Map<String, RenderUnit> siblings) {
        this.siblings = siblings;
    }

    private Bindings buildGlobalScope(Bindings bindings) {
        CaseInsensitiveBindings caseInsensitiveBindings = new CaseInsensitiveBindings(bindings);
        if (this.siblings != null) {
            caseInsensitiveBindings.putAll((Map<? extends String, ?>)this.siblings);
        }
        caseInsensitiveBindings.putAll((Map<? extends String, ?>)this.subTemplates);
        return caseInsensitiveBindings;
    }

    private static final class CaseInsensitiveBindings
    implements Bindings {
        private final Map<String, Object> wrapped;
        private final Map<String, String> keyMappings;

        private CaseInsensitiveBindings(Map<String, Object> wrapped) {
            this.wrapped = wrapped;
            this.keyMappings = new HashMap<String, String>();
            for (String key : this.wrapped.keySet()) {
                this.keyMappings.put(key.toLowerCase(), key);
            }
        }

        @Override
        public Object get(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            String mappedKey = this.keyMappings.get(((String)key).toLowerCase());
            if (mappedKey != null) {
                return this.wrapped.get(mappedKey);
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            return this.keyMappings.containsKey(((String)key).toLowerCase());
        }

        @Override
        public Object put(String key, Object value) {
            this.keyMappings.put(key.toLowerCase(), key);
            return this.wrapped.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ?> toMerge) {
            for (Map.Entry<String, ?> entry : toMerge.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            String originalKey = this.keyMappings.remove(((String)key).toLowerCase());
            if (originalKey != null) {
                return this.wrapped.remove(originalKey);
            }
            return null;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.wrapped.containsValue(value);
        }

        @Override
        public void clear() {
            this.wrapped.clear();
            this.keyMappings.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.keyMappings.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.wrapped.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
            for (Map.Entry<String, String> entry : this.keyMappings.entrySet()) {
                entrySet.add(new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), this.wrapped.get(entry.getValue())));
            }
            return entrySet;
        }
    }

    protected static class FluentMap
    extends HashMap<String, Object> {
        protected FluentMap() {
        }

        public FluentMap with(String name, Object value) {
            this.put(name, value);
            return this;
        }
    }
}

