/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.thymeleaf.internal.ThymeleafScriptEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;

public final class ThymeleafScriptEngine
extends AbstractSlingScriptEngine {
    private final ThymeleafScriptEngineFactory thymeleafScriptEngineFactory;
    private final Logger logger = LoggerFactory.getLogger(ThymeleafScriptEngine.class);

    public ThymeleafScriptEngine(ThymeleafScriptEngineFactory thymeleafScriptEngineFactory) {
        super((ScriptEngineFactory)((Object)thymeleafScriptEngineFactory));
        this.thymeleafScriptEngineFactory = thymeleafScriptEngineFactory;
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        Bindings bindings = scriptContext.getBindings(100);
        SlingScriptHelper helper = (SlingScriptHelper)bindings.get("sling");
        if (helper == null) {
            throw new ScriptException("SlingScriptHelper missing from bindings");
        }
        SlingHttpServletRequest request = helper.getRequest();
        SlingHttpServletResponse response = helper.getResponse();
        ServletContext servletContext = this.thymeleafScriptEngineFactory.getSlingServletContext();
        Locale locale = helper.getResponse().getLocale();
        String scriptName = helper.getScript().getScriptResource().getPath();
        Writer writer = scriptContext.getWriter();
        try {
            WebContext context = new WebContext((HttpServletRequest)request, (HttpServletResponse)response, servletContext, locale, (Map)bindings);
            this.thymeleafScriptEngineFactory.getTemplateEngine().process(scriptName, (IContext)context, writer);
        }
        catch (Exception e) {
            this.logger.error("Failure rendering Thymeleaf template '{}': {}", (Object)scriptName, (Object)e.getMessage());
            throw new ScriptException(e);
        }
        return null;
    }
}

