/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionMoveOperation
implements SessionWriteOperation<Object> {
    private final Logger log = LoggerFactory.getLogger(SessionMoveOperation.class);
    private final String srcAbsPath;
    private final Path srcPath;
    private final String destAbsPath;
    private final Path destPath;

    public SessionMoveOperation(PathResolver resolver, String srcAbsPath, String destAbsPath) throws RepositoryException {
        this.srcAbsPath = srcAbsPath;
        this.srcPath = this.getAbsolutePath(resolver, srcAbsPath);
        this.destAbsPath = destAbsPath;
        this.destPath = this.getAbsolutePath(resolver, destAbsPath);
        if (this.destPath.getIndex() != 0) {
            String msg = destAbsPath + ": invalid destination path (subscript in name element is not allowed)";
            this.log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (this.srcPath.isAncestorOf(this.destPath)) {
            throw new RepositoryException("Destination path " + destAbsPath + " cannot be descendant of source path " + srcAbsPath + " in a move operation.");
        }
    }

    private Path getAbsolutePath(PathResolver resolver, String path) throws RepositoryException {
        try {
            Path qpath = resolver.getQPath(path).getNormalizedPath();
            if (!qpath.isAbsolute()) {
                throw new RepositoryException("Path is not absolute: " + path);
            }
            return qpath;
        }
        catch (NameException e) {
            throw new RepositoryException("Path is invalid: " + path, (Throwable)((Object)e));
        }
    }

    private NodeImpl getNode(SessionContext context, Path path, String absPath) throws RepositoryException {
        try {
            return context.getItemManager().getNode(path);
        }
        catch (AccessDeniedException e) {
            throw new PathNotFoundException("Path not found: " + absPath);
        }
    }

    @Override
    public Object perform(SessionContext context) throws RepositoryException {
        NodeDefinitionImpl newTargetDef;
        NodeImpl targetNode = this.getNode(context, this.srcPath, this.srcAbsPath);
        NodeImpl srcParentNode = this.getNode(context, this.srcPath.getAncestor(1), this.srcAbsPath);
        NodeImpl destParentNode = this.getNode(context, this.destPath.getAncestor(1), this.destAbsPath);
        if (context.getHierarchyManager().isShareAncestor(targetNode.getNodeId(), destParentNode.getNodeId())) {
            throw new RepositoryException("Move not possible because of a share cycle between " + this.srcAbsPath + " and " + this.destAbsPath);
        }
        NodeImpl existing = null;
        try {
            existing = context.getItemManager().getNode(this.destPath);
            if (!existing.getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException("Same name siblings are not allowed: " + existing);
            }
        }
        catch (AccessDeniedException ade) {
            throw new ItemExistsException(this.destAbsPath);
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        int options = 406;
        context.getItemValidator().checkRemove(srcParentNode, options, 0);
        context.getItemValidator().checkModify(destParentNode, options, 0);
        NodeTypeImpl nt = (NodeTypeImpl)targetNode.getPrimaryNodeType();
        try {
            newTargetDef = destParentNode.getApplicableChildNodeDefinition(this.destPath.getName(), nt.getQName());
        }
        catch (RepositoryException re) {
            String msg = this.destAbsPath + ": no definition found in parent node's node type for new node";
            this.log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)re);
        }
        if (existing != null && !newTargetDef.allowsSameNameSiblings()) {
            throw new ItemExistsException("Same name siblings not allowed: " + existing);
        }
        NodeId targetId = targetNode.getNodeId();
        int index = this.srcPath.getNormalizedIndex();
        AccessManager acMgr = context.getAccessManager();
        if (!acMgr.isGranted(this.srcPath, 8) || !acMgr.isGranted(this.destPath, 132)) {
            String msg = "Not allowed to move node " + this.srcAbsPath + " to " + this.destAbsPath;
            this.log.debug(msg);
            throw new AccessDeniedException(msg);
        }
        if (srcParentNode.isSame(destParentNode)) {
            targetNode.onRedefine(newTargetDef.unwrap());
            destParentNode.renameChildNode(targetId, this.destPath.getName(), false);
        } else {
            if (targetNode.getNodeState().isShareable()) {
                String msg = "Moving a shareable node is not supported.";
                this.log.debug(msg);
                throw new UnsupportedRepositoryOperationException(msg);
            }
            targetNode.onRedefine(newTargetDef.unwrap());
            NodeState srcParentState = (NodeState)srcParentNode.getOrCreateTransientItemState();
            NodeState targetState = (NodeState)targetNode.getOrCreateTransientItemState();
            NodeState destParentState = (NodeState)destParentNode.getOrCreateTransientItemState();
            if (srcParentState.removeChildNodeEntry(targetId)) {
                targetState.setParentId(destParentNode.getNodeId());
                destParentState.addChildNodeEntry(this.destPath.getName(), targetId);
            }
        }
        return this;
    }

    public String toString() {
        return "session.move(" + this.srcAbsPath + ", " + this.destAbsPath + ")";
    }
}

