/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DecimalField;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IDField;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.LazyTextExtractorField;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SingletonTokenStream;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIndexer {
    private static final Logger log = LoggerFactory.getLogger(NodeIndexer.class);
    protected static final float DEFAULT_BOOST = 1.0f;
    protected final NodeState node;
    protected final ItemStateManager stateProvider;
    protected final NamespaceMappings mappings;
    protected final NamePathResolver resolver;
    private final Executor executor;
    private final Parser parser;
    protected IndexingConfiguration indexingConfig;
    protected boolean supportHighlighting = false;
    protected IndexFormatVersion indexFormatVersion = IndexFormatVersion.V1;
    protected List<Fieldable> doNotUseInExcerpt = new ArrayList<Fieldable>();
    private int maxExtractLength = Integer.MAX_VALUE;

    public NodeIndexer(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, Executor executor, Parser parser) {
        this.node = node;
        this.stateProvider = stateProvider;
        this.mappings = mappings;
        this.resolver = NamePathResolverImpl.create(mappings);
        this.executor = executor;
        this.parser = parser;
    }

    public NodeId getNodeId() {
        return this.node.getNodeId();
    }

    public void setSupportHighlighting(boolean b) {
        this.supportHighlighting = b;
    }

    public void setIndexFormatVersion(IndexFormatVersion indexFormatVersion) {
        this.indexFormatVersion = indexFormatVersion;
    }

    public void setIndexingConfiguration(IndexingConfiguration config) {
        this.indexingConfig = config;
    }

    public int getMaxExtractLength() {
        return this.maxExtractLength;
    }

    public void setMaxExtractLength(int length) {
        this.maxExtractLength = length;
    }

    public Document createDoc() throws RepositoryException {
        this.doNotUseInExcerpt.clear();
        Document doc = new Document();
        doc.setBoost(this.getNodeBoost());
        doc.add((Fieldable)new IDField(this.node.getNodeId()));
        try {
            if (this.node.getParentId() == null) {
                doc.add((Fieldable)new Field(FieldNames.PARENT, "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                this.addNodeName(doc, "", "");
            } else if (this.node.getSharedSet().isEmpty()) {
                this.addParentChildRelation(doc, this.node.getParentId());
            } else {
                for (NodeId id : this.node.getSharedSet()) {
                    this.addParentChildRelation(doc, id);
                }
                doc.add((Fieldable)new Field(FieldNames.SHAREABLE_NODE, "", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
        catch (NoSuchItemStateException e) {
            this.throwRepositoryException(e);
        }
        catch (ItemStateException e) {
            this.throwRepositoryException(e);
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        Set<Name> props = this.node.getPropertyNames();
        for (Name propName : props) {
            PropertyId id = new PropertyId(this.node.getNodeId(), propName);
            try {
                InternalValue[] values;
                PropertyState propState = (PropertyState)this.stateProvider.getItemState(id);
                if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V2.getVersion()) {
                    this.addPropertyName(doc, propState.getName());
                }
                for (InternalValue value : values = propState.getValues()) {
                    this.addValue(doc, value, propState.getName());
                }
                if (values.length <= 1) continue;
                this.addMVPName(doc, propState.getName());
            }
            catch (NoSuchItemStateException e) {
                this.throwRepositoryException(e);
            }
            catch (ItemStateException e) {
                this.throwRepositoryException(e);
            }
        }
        for (Fieldable field : this.doNotUseInExcerpt) {
            doc.add(field);
        }
        return doc;
    }

    protected void throwRepositoryException(Exception e) throws RepositoryException {
        String msg = "Error while indexing node: " + this.node.getNodeId() + " of " + "type: " + this.node.getNodeTypeName();
        throw new RepositoryException(msg, (Throwable)e);
    }

    protected void addMVPName(Document doc, Name name) {
        try {
            String propName = this.resolver.getJCRName(name);
            doc.add((Fieldable)new Field(FieldNames.MVP, propName, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    protected void addValue(Document doc, InternalValue value, Name name) throws RepositoryException {
        String fieldName = name.getLocalName();
        try {
            fieldName = this.resolver.getJCRName(name);
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        switch (value.getType()) {
            case 2: {
                if (!this.isIndexed(name)) break;
                this.addBinaryValue(doc, fieldName, value);
                break;
            }
            case 6: {
                if (!this.isIndexed(name)) break;
                this.addBooleanValue(doc, fieldName, value.getBoolean());
                break;
            }
            case 5: {
                if (!this.isIndexed(name)) break;
                this.addCalendarValue(doc, fieldName, value.getDate());
                break;
            }
            case 4: {
                if (!this.isIndexed(name)) break;
                this.addDoubleValue(doc, fieldName, value.getDouble());
                break;
            }
            case 3: {
                if (!this.isIndexed(name)) break;
                this.addLongValue(doc, fieldName, value.getLong());
                break;
            }
            case 9: {
                if (!this.isIndexed(name)) break;
                this.addReferenceValue(doc, fieldName, value.getNodeId(), false);
                break;
            }
            case 10: {
                if (!this.isIndexed(name)) break;
                this.addReferenceValue(doc, fieldName, value.getNodeId(), true);
                break;
            }
            case 8: {
                if (!this.isIndexed(name)) break;
                this.addPathValue(doc, fieldName, value.getPath());
                break;
            }
            case 11: {
                if (!this.isIndexed(name)) break;
                this.addURIValue(doc, fieldName, value.getURI());
                break;
            }
            case 1: {
                if (!this.isIndexed(name)) break;
                if (name.equals(NameConstants.JCR_UUID)) {
                    this.addStringValue(doc, fieldName, value.getString(), false, false, 1.0f);
                    break;
                }
                this.addStringValue(doc, fieldName, value.getString(), true, this.isIncludedInNodeIndex(name), this.getPropertyBoost(name), this.useInExcerpt(name));
                break;
            }
            case 7: {
                if (!name.equals(NameConstants.JCR_PRIMARYTYPE) && !name.equals(NameConstants.JCR_MIXINTYPES) && !this.isIndexed(name)) break;
                this.addNameValue(doc, fieldName, value.getName());
                break;
            }
            case 12: {
                if (!this.isIndexed(name)) break;
                this.addDecimalValue(doc, fieldName, value.getDecimal());
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal internal value type: " + value.getType());
            }
        }
        this.addValueProperty(doc, value, name, fieldName);
    }

    protected void addValueProperty(Document doc, InternalValue value, Name name, String fieldName) throws RepositoryException {
        if (!this.isIndexed(name)) {
            return;
        }
        if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            this.addLength(doc, fieldName, value);
        }
    }

    protected void addPropertyName(Document doc, Name name) {
        String fieldName = name.getLocalName();
        try {
            fieldName = this.resolver.getJCRName(name);
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        doc.add((Fieldable)new Field(FieldNames.PROPERTIES_SET, fieldName, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
    }

    protected void addBinaryValue(Document doc, String fieldName, InternalValue internalValue) {
        try {
            String jcrData = this.mappings.getPrefix("http://www.jcp.org/jcr/1.0") + ":data";
            if (!jcrData.equals(fieldName)) {
                return;
            }
            InternalValue type = this.getValue(NameConstants.JCR_MIMETYPE);
            if (type != null) {
                Metadata metadata = new Metadata();
                metadata.set("Content-Type", type.getString());
                InternalValue encoding = this.getValue(NameConstants.JCR_ENCODING);
                if (encoding != null) {
                    metadata.set("Content-Encoding", encoding.getString());
                }
                doc.add(this.createFulltextField(internalValue, metadata));
            }
        }
        catch (Throwable t) {
            log.warn("Exception while indexing binary property", t);
        }
    }

    protected InternalValue getValue(Name name) throws ItemStateException {
        try {
            PropertyId id = new PropertyId(this.node.getNodeId(), name);
            PropertyState property = (PropertyState)this.stateProvider.getItemState(id);
            InternalValue[] values = property.getValues();
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        catch (NoSuchItemStateException e) {
            return null;
        }
    }

    protected void addBooleanValue(Document doc, String fieldName, Object internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), 6));
    }

    protected Field createFieldWithoutNorms(String fieldName, String internalValue, int propertyType) {
        if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            Field field = new Field(FieldNames.PROPERTIES, (TokenStream)new SingletonTokenStream(FieldNames.createNamedValue(fieldName, internalValue), propertyType));
            field.setOmitNorms(true);
            return field;
        }
        return new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, internalValue), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO);
    }

    protected void addCalendarValue(Document doc, String fieldName, Calendar internalValue) {
        try {
            doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DateField.timeToString(internalValue.getTimeInMillis()), 5));
        }
        catch (IllegalArgumentException e) {
            log.warn("'{}' is outside of supported date value range.", (Object)internalValue);
        }
    }

    protected void addDoubleValue(Document doc, String fieldName, double internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DoubleField.doubleToString(internalValue), 4));
    }

    protected void addLongValue(Document doc, String fieldName, long internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, LongField.longToString(internalValue), 3));
    }

    protected void addDecimalValue(Document doc, String fieldName, BigDecimal internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DecimalField.decimalToString(internalValue), 12));
    }

    protected void addReferenceValue(Document doc, String fieldName, NodeId internalValue, boolean weak) {
        String uuid = internalValue.toString();
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, uuid, weak ? 10 : 9));
        doc.add((Fieldable)new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, uuid), Field.Store.YES, Field.Index.NO, Field.TermVector.NO));
        if (weak) {
            doc.add((Fieldable)new Field(FieldNames.WEAK_REFS, uuid, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }

    protected void addPathValue(Document doc, String fieldName, Path internalValue) {
        String pathString = internalValue.toString();
        try {
            pathString = this.resolver.getJCRPath(internalValue);
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, pathString, 8));
    }

    protected void addURIValue(Document doc, String fieldName, URI internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), 11));
    }

    protected void addStringValue(Document doc, String fieldName, String internalValue) {
        this.addStringValue(doc, fieldName, internalValue, true, true, 1.0f);
    }

    protected void addStringValue(Document doc, String fieldName, String internalValue, boolean tokenized) {
        this.addStringValue(doc, fieldName, internalValue, tokenized, true, 1.0f);
    }

    protected void addStringValue(Document doc, String fieldName, String internalValue, boolean tokenized, boolean includeInNodeIndex, float boost) {
        this.addStringValue(doc, fieldName, internalValue, tokenized, includeInNodeIndex, boost, true);
    }

    protected void addStringValue(Document doc, String fieldName, String internalValue, boolean tokenized, boolean includeInNodeIndex, float boost, boolean useInExcerpt) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue, 1));
        if (tokenized) {
            if (internalValue.length() == 0) {
                return;
            }
            int idx = fieldName.indexOf(58);
            fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1);
            Field f = new Field(fieldName, internalValue, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
            f.setBoost(boost);
            doc.add((Fieldable)f);
            if (includeInNodeIndex) {
                boolean store = this.supportHighlighting && useInExcerpt;
                f = this.createFulltextField(internalValue, store, this.supportHighlighting);
                if (useInExcerpt) {
                    doc.add((Fieldable)f);
                } else {
                    this.doNotUseInExcerpt.add((Fieldable)f);
                }
            }
        }
    }

    protected void addNameValue(Document doc, String fieldName, Name internalValue) {
        try {
            String normValue = this.mappings.getPrefix(internalValue.getNamespaceURI()) + ":" + internalValue.getLocalName();
            doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, normValue, 7));
        }
        catch (NamespaceException e) {
            // empty catch block
        }
    }

    protected Field createFulltextField(String value) {
        return this.createFulltextField(value, this.supportHighlighting, this.supportHighlighting);
    }

    protected Field createFulltextField(String value, boolean store, boolean withOffsets) {
        Field.TermVector tv = withOffsets ? Field.TermVector.WITH_OFFSETS : Field.TermVector.NO;
        if (store) {
            Field.Store stored = value.length() > 16384 ? Field.Store.COMPRESS : Field.Store.YES;
            return new Field(FieldNames.FULLTEXT, value, stored, Field.Index.ANALYZED, tv);
        }
        return new Field(FieldNames.FULLTEXT, value, Field.Store.NO, Field.Index.ANALYZED, tv);
    }

    protected Fieldable createFulltextField(InternalValue value, Metadata metadata) {
        return new LazyTextExtractorField(this.parser, value, metadata, this.executor, this.supportHighlighting, this.getMaxExtractLength());
    }

    protected boolean isIndexed(Name propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.isIndexed(this.node, propertyName);
    }

    protected boolean isIncludedInNodeIndex(Name propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.isIncludedInNodeScopeIndex(this.node, propertyName);
    }

    protected boolean useInExcerpt(Name propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.useInExcerpt(this.node, propertyName);
    }

    protected float getPropertyBoost(Name propertyName) {
        if (this.indexingConfig == null) {
            return 1.0f;
        }
        return this.indexingConfig.getPropertyBoost(this.node, propertyName);
    }

    protected float getNodeBoost() {
        if (this.indexingConfig == null) {
            return 1.0f;
        }
        return this.indexingConfig.getNodeBoost(this.node);
    }

    protected void addLength(Document doc, String propertyName, InternalValue value) {
        long length = Util.getLength(value);
        if (length != -1L) {
            doc.add((Fieldable)new Field(FieldNames.PROPERTY_LENGTHS, FieldNames.createNamedLength(propertyName, length), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }

    protected void addNodeName(Document doc, String namespaceURI, String localName) throws NamespaceException {
        String name = this.mappings.getPrefix(namespaceURI) + ":" + localName;
        doc.add((Fieldable)new Field(FieldNames.LABEL, name, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            doc.add((Fieldable)new Field(FieldNames.NAMESPACE_URI, namespaceURI, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field(FieldNames.LOCAL_NAME, localName, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }

    protected void addParentChildRelation(Document doc, NodeId parentId) throws ItemStateException, RepositoryException {
        doc.add((Fieldable)new Field(FieldNames.PARENT, parentId.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        NodeState parent = (NodeState)this.stateProvider.getItemState(parentId);
        ChildNodeEntry child = parent.getChildNodeEntry(this.node.getNodeId());
        if (child == null) {
            throw new RepositoryException("Missing child node entry for node with id: " + this.node.getNodeId());
        }
        Name name = child.getName();
        this.addNodeName(doc, name.getNamespaceURI(), name.getLocalName());
    }
}

