/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.core.helpers.CyclicBuffer;
import java.util.Arrays;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.tracer.internal.Recording;
import org.apache.sling.tracer.internal.TracerConfig;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

class TracerContext {
    static final String QUERY_LOGGER = "org.apache.jackrabbit.oak.query.QueryEngineImpl";
    private static final String[] IGNORABLE_QUERIES = new String[]{"SELECT * FROM [nt:base] WHERE [jcr:uuid] = $id", "SELECT * FROM [nt:base] WHERE PROPERTY([rep:members], 'WeakReference') = $uuid", "SELECT * FROM [rep:Authorizable]WHERE [rep:principalName] = $principalName"};
    private static final int LOG_BUFFER_SIZE = 50;
    private CyclicBuffer<String> buffer;
    private RequestProgressTracker progressTracker;
    private int queryCount;
    private final TracerConfig[] tracers;
    private final Recording recording;

    public TracerContext(TracerConfig[] tracers, Recording recording) {
        this.tracers = tracers;
        this.recording = recording;
        Arrays.sort(tracers);
    }

    public TracerConfig findMatchingConfig(String logger, Level level) {
        for (TracerConfig tc : this.tracers) {
            TracerConfig.MatchResult mr = tc.match(logger, level);
            if (mr == TracerConfig.MatchResult.MATCH_LOG) {
                return tc;
            }
            if (mr != TracerConfig.MatchResult.MATCH_NO_LOG) continue;
            return null;
        }
        return null;
    }

    public boolean log(TracerConfig tc, Level level, String logger, String format, Object[] params) {
        FormattingTuple tuple = null;
        if (QUERY_LOGGER.equals(logger) && params != null && params.length == 2) {
            if (this.logQuery(String.valueOf(params[1]))) {
                tuple = this.logWithLoggerName(logger, format, params);
            }
        } else {
            tuple = this.logWithLoggerName(logger, format, params);
        }
        if (tuple != null) {
            this.recording.log(tc, level, logger, tuple);
        }
        return tuple != null;
    }

    public void recordCategory(String loggerName) {
        this.recording.recordCategory(loggerName);
    }

    public void done() {
        if (this.queryCount > 0) {
            this.progressTracker.log("JCR Query Count {0}", new Object[]{this.queryCount});
        }
    }

    public void registerProgressTracker(RequestProgressTracker requestProgressTracker) {
        this.progressTracker = requestProgressTracker;
        if (this.buffer != null) {
            for (String msg : this.buffer.asList()) {
                this.progressTracker.log(msg);
            }
            this.buffer = null;
        }
    }

    private FormattingTuple logWithLoggerName(String loggerName, String format, Object ... params) {
        FormattingTuple tuple = MessageFormatter.arrayFormat((String)format, (Object[])params);
        String msg = tuple.getMessage();
        msg = "[" + loggerName + "] " + msg;
        if (this.progressTracker == null) {
            if (this.buffer == null) {
                this.buffer = new CyclicBuffer(50);
            }
            this.buffer.add((Object)msg);
        } else {
            this.progressTracker.log(msg);
        }
        return tuple;
    }

    private boolean logQuery(String query) {
        if (this.ignorableQuery(query)) {
            return false;
        }
        ++this.queryCount;
        return true;
    }

    private boolean ignorableQuery(String msg) {
        for (String ignorableQuery : IGNORABLE_QUERIES) {
            if (!msg.contains(ignorableQuery)) continue;
            return true;
        }
        return false;
    }
}

