/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

abstract class AbstractBundleRequestMojo
extends AbstractMojo {
    @Parameter(property="sling.url", defaultValue="http://localhost:8080/system/console", required=true)
    protected URI slingUrl;
    @Parameter(property="sling.console.url")
    protected URI slingConsoleUrl;
    @Parameter(property="sling.urlSuffix")
    protected String slingUrlSuffix;
    @Parameter(property="sling.user", defaultValue="admin")
    private String user;
    @Parameter(property="sling.password", defaultValue="admin")
    private String password;
    @Parameter(property="sling.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="sling.httpConnectTimeoutSec", defaultValue="10")
    private int httpConnectTimeoutSec;
    @Parameter(property="sling.httpResponseTimeoutSec", defaultValue="60")
    private int httpResponseTimeoutSec;
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;

    AbstractBundleRequestMojo() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getBundleSymbolicName(File jarFile) {
        if (!jarFile.exists()) {
            return null;
        }
        try (JarFile jaf = new JarFile(jarFile);){
            Manifest manif = jaf.getManifest();
            if (manif == null) {
                this.getLog().debug((CharSequence)("getBundleSymbolicName: Missing manifest in " + jarFile));
                String string = null;
                return string;
            }
            String symbName = manif.getMainAttributes().getValue("Bundle-SymbolicName");
            if (symbName == null) {
                this.getLog().debug((CharSequence)("getBundleSymbolicName: No Bundle-SymbolicName in " + jarFile));
                String string = null;
                return string;
            }
            String string = symbName;
            return string;
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)("getBundleSymbolicName: Problem checking " + jarFile), (Throwable)ioe);
            return null;
        }
    }

    protected URI getTargetURL() {
        URI targetURL = this.slingUrlSuffix != null ? this.slingUrl.resolve(this.slingUrlSuffix) : this.slingUrl;
        return AbstractBundleRequestMojo.addTrailingSlash(targetURL);
    }

    protected URI getConsoleTargetURL() {
        URI targetURL;
        URI uRI = targetURL = this.slingConsoleUrl != null ? this.slingConsoleUrl : this.slingUrl;
        if (this.slingUrlSuffix != null) {
            targetURL = targetURL.resolve(this.slingUrlSuffix);
        }
        return AbstractBundleRequestMojo.addTrailingSlash(targetURL);
    }

    public static URI addTrailingSlash(URI targetURL) {
        if (!targetURL.getPath().endsWith("/")) {
            String path = targetURL.getPath() + "/";
            try {
                return new URI(targetURL.getScheme(), targetURL.getUserInfo(), targetURL.getHost(), targetURL.getPort(), path, targetURL.getQuery(), targetURL.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Could not create new URI from existing one", e);
            }
        }
        return targetURL;
    }

    protected CloseableHttpClient getHttpClient() {
        BasicScheme basicAuth = new BasicScheme();
        basicAuth.initPreemptive((Credentials)new UsernamePasswordCredentials(this.user, this.password.toCharArray()));
        HttpHost target = new HttpHost(this.getTargetURL().getScheme(), this.getTargetURL().getHost(), this.getTargetURL().getPort());
        return HttpClients.custom().setDefaultRequestConfig(this.getRequestConfigBuilder().build()).addRequestInterceptorFirst((HttpRequestInterceptor)new PreemptiveBasicAuthInterceptor(basicAuth, target, this.getLog())).build();
    }

    protected RequestConfig.Builder getRequestConfigBuilder() {
        return RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)this.httpConnectTimeoutSec)).setResponseTimeout(Timeout.ofSeconds((long)this.httpResponseTimeoutSec));
    }

    protected File resolveArtifact(Artifact artifact) throws MojoExecutionException {
        ArtifactRequest req = new ArtifactRequest(artifact, this.getRemoteRepositoriesWithUpdatePolicy(this.repositories, "always"), null);
        try {
            ArtifactResult resolutionResult = this.repoSystem.resolveArtifact(this.repoSession, req);
            return resolutionResult.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Artifact " + artifact + " could not be resolved.", (Exception)((Object)e));
        }
    }

    private List<RemoteRepository> getRemoteRepositoriesWithUpdatePolicy(List<RemoteRepository> repositories, String updatePolicy) {
        ArrayList<RemoteRepository> newRepositories = new ArrayList<RemoteRepository>();
        for (RemoteRepository repo : repositories) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repo);
            RepositoryPolicy newPolicy = new RepositoryPolicy(repo.getPolicy(false).isEnabled(), updatePolicy, repo.getPolicy(false).getChecksumPolicy());
            builder.setPolicy(newPolicy);
            newRepositories.add(builder.build());
        }
        return newRepositories;
    }

    private static final class PreemptiveBasicAuthInterceptor
    implements HttpRequestInterceptor {
        private final BasicScheme basicAuth;
        private final HttpHost targetHost;
        private final Log log;

        public PreemptiveBasicAuthInterceptor(BasicScheme basicAuth, HttpHost targetHost, Log log) {
            this.basicAuth = basicAuth;
            this.targetHost = targetHost;
            this.log = log;
        }

        public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
            if (!(context instanceof HttpClientContext)) {
                throw new IllegalStateException("This interceptor only supports HttpClientContext but context is of type " + context.getClass());
            }
            HttpClientContext httpClientContext = (HttpClientContext)context;
            this.log.debug((CharSequence)("Adding preemptive authentication to request for target host " + this.targetHost));
            httpClientContext.getAuthExchange(this.targetHost).select((AuthScheme)this.basicAuth);
        }
    }
}

