/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;
import org.apache.derby.impl.sql.compile.WindowReferenceNode;

public abstract class WindowFunctionNode
extends UnaryOperatorNode {
    private WindowNode window;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    public void init(Object object, Object object2, Object object3) {
        super.init(object, object2, null);
        this.window = (WindowNode)object3;
    }

    public boolean isConstantExpression() {
        return false;
    }

    public boolean constantExpression(PredicateList predicateList) {
        return false;
    }

    public WindowNode getWindow() {
        return this.window;
    }

    public void setWindow(WindowDefinitionNode windowDefinitionNode) {
        this.window = windowDefinitionNode;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        if (this.window instanceof WindowReferenceNode) {
            WindowDefinitionNode windowDefinitionNode = this.definedWindow(fromList.getWindows(), this.window.getName());
            if (windowDefinitionNode != null) {
                this.window = windowDefinitionNode;
            } else {
                throw StandardException.newException("42ZC0", this.window.getName());
            }
        }
        return this;
    }

    private WindowDefinitionNode definedWindow(WindowList windowList, String string) {
        for (int i = 0; i < windowList.size(); ++i) {
            WindowDefinitionNode windowDefinitionNode = (WindowDefinitionNode)windowList.elementAt(i);
            if (!windowDefinitionNode.getName().equals(string)) continue;
            return windowDefinitionNode;
        }
        return null;
    }

    public void printSubNodes(int n) {
    }

    public ValueNode replaceCallsWithColumnReferences(ResultColumnList resultColumnList, int n) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext compilerContext = this.getCompilerContext();
            String string = "SQLCol" + compilerContext.getNextColumnNumber();
            this.generatedRC = (ResultColumn)this.getNodeFactory().getNode(80, string, this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = (ColumnReference)this.getNodeFactory().getNode(62, this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (n != -1) {
                this.generatedRef.setTableNumber(n);
            }
            resultColumnList.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceWindowFunctionCall();
        } else {
            resultColumnList.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    public ColumnReference getGeneratedRef() {
        return this.generatedRef;
    }

    public ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }
}

