/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BaseContainer;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.DropOnCommit;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.impl.store.raw.data.SyncOnCommit;
import org.apache.derby.impl.store.raw.data.TruncateOnCommit;

public class BaseContainerHandle
extends Observable
implements RawContainerHandle,
Observer {
    private ContainerKey identity;
    private boolean active;
    protected BaseContainer container;
    private LockingPolicy locking;
    private RawTransaction xact;
    private boolean forUpdate;
    private int mode;
    private PageActions actionsSet;
    private AllocationActions allocActionsSet;

    public BaseContainerHandle(UUID uUID, RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n) {
        this.identity = containerKey;
        this.xact = rawTransaction;
        this.locking = lockingPolicy;
        this.mode = n;
        this.forUpdate = (n & 4) == 4;
    }

    public BaseContainerHandle(UUID uUID, RawTransaction rawTransaction, PageActions pageActions, AllocationActions allocationActions, LockingPolicy lockingPolicy, BaseContainer baseContainer, int n) {
        this(uUID, rawTransaction, (ContainerKey)baseContainer.getIdentity(), lockingPolicy, n);
        this.actionsSet = pageActions;
        this.allocActionsSet = allocationActions;
        this.container = baseContainer;
    }

    public Page addPage() throws StandardException {
        this.checkUpdateOpen();
        Page page = this.container.addPage(this, false);
        return page;
    }

    public void compressContainer() throws StandardException {
        this.checkUpdateOpen();
        this.container.compressContainer(this);
    }

    public long getReusableRecordIdSequenceNumber() throws StandardException {
        this.checkOpen();
        return this.container.getReusableRecordIdSequenceNumber();
    }

    public Page addPage(int n) throws StandardException {
        if ((n & 2) != 0 && this.active && this.forUpdate) {
            this.container.clearPreallocThreshold();
        }
        return this.addPage();
    }

    public void preAllocate(int n) {
        if (n > 0 && this.active && this.forUpdate) {
            this.container.prepareForBulkLoad(this, n);
        }
    }

    public void getContainerProperties(Properties properties) throws StandardException {
        this.checkOpen();
        this.container.getContainerProperties(properties);
    }

    public void removePage(Page page) throws StandardException {
        if (!this.active) {
            if (page != null) {
                page.unlatch();
            }
            throw StandardException.newException("40XD0");
        }
        if (!this.forUpdate) {
            if (page != null) {
                page.unlatch();
            }
            throw StandardException.newException("40XD1");
        }
        this.container.removePage(this, (BasePage)page);
    }

    public Page getPage(long l) throws StandardException {
        this.checkOpen();
        return this.container.getPage(this, l, true);
    }

    public Page getAllocPage(long l) throws StandardException {
        this.checkOpen();
        return this.container.getAllocPage(this, l, true);
    }

    public Page getUserPageNoWait(long l) throws StandardException {
        this.checkOpen();
        return this.container.getHeadPage(this, l, false);
    }

    public Page getUserPageWait(long l) throws StandardException {
        this.checkOpen();
        return this.container.getHeadPage(this, l, true);
    }

    public Page getPageNoWait(long l) throws StandardException {
        this.checkOpen();
        return this.container.getPage(this, l, false);
    }

    public Page getFirstPage() throws StandardException {
        this.checkOpen();
        return this.container.getFirstPage(this);
    }

    public Page getNextPage(long l) throws StandardException {
        this.checkOpen();
        return this.container.getNextPage(this, l);
    }

    public Page getPageForInsert(int n) throws StandardException {
        this.checkUpdateOpen();
        return this.container.getPageForInsert(this, n);
    }

    public Page getPageForCompress(int n, long l) throws StandardException {
        this.checkUpdateOpen();
        return this.container.getPageForCompress(this, n, l);
    }

    public final boolean isReadOnly() {
        return !this.forUpdate;
    }

    public synchronized void close() {
        if (this.xact == null) {
            return;
        }
        this.informObservers();
        this.active = false;
        this.getLockingPolicy().unlockContainer(this.xact, this);
        if (this.container != null) {
            this.container.letGo(this);
            this.container = null;
        }
        this.xact.deleteObserver(this);
        this.xact = null;
    }

    public long getEstimatedRowCount(int n) throws StandardException {
        this.checkOpen();
        return this.container.getEstimatedRowCount(n);
    }

    public void setEstimatedRowCount(long l, int n) throws StandardException {
        this.checkOpen();
        this.container.setEstimatedRowCount(l, n);
    }

    public long getEstimatedPageCount(int n) throws StandardException {
        this.checkOpen();
        return this.container.getEstimatedPageCount(this, n);
    }

    public void flushContainer() throws StandardException {
        this.checkUpdateOpen();
        this.container.flushAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRecord(RecordHandle recordHandle) throws StandardException {
        if (!this.forUpdate) {
            throw StandardException.newException("40XD1");
        }
        PageKey pageKey = (PageKey)recordHandle.getPageId();
        BasePage basePage = (BasePage)this.getPage(pageKey.getPageNumber());
        if (basePage != null) {
            try {
                basePage.compactRecord(recordHandle);
                Object var5_4 = null;
                basePage.unlatch();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                basePage.unlatch();
                throw throwable;
            }
        }
    }

    public int getContainerStatus() throws StandardException {
        this.checkOpen();
        return this.container.getContainerStatus();
    }

    public void removeContainer(LogInstant logInstant) throws StandardException {
        this.checkUpdateOpen();
        this.container.removeContainer(logInstant, true);
    }

    public ContainerKey getId() {
        return this.identity;
    }

    public Object getUniqueId() {
        return this;
    }

    public void dropContainer(LogInstant logInstant, boolean bl) throws StandardException {
        this.checkUpdateOpen();
        this.container.dropContainer(logInstant, bl);
    }

    public long getContainerVersion() throws StandardException {
        this.checkOpen();
        return this.container.getContainerVersion();
    }

    public Page getAnyPage(long l) throws StandardException {
        this.checkOpen();
        return this.container.getAnyPage(this, l, true);
    }

    public Page reCreatePageForRedoRecovery(int n, long l, long l2) throws StandardException {
        this.checkUpdateOpen();
        return this.container.reCreatePageForRedoRecovery(this, n, l, l2);
    }

    public ByteArray logCreateContainerInfo() throws StandardException {
        this.checkUpdateOpen();
        return this.container.logCreateContainerInfo();
    }

    public RecordHandle makeRecordHandle(long l, int n) throws StandardException {
        return new RecordId(this.identity, l, n);
    }

    public void update(Observable observable, Object object) {
        if (this.xact == null) {
            return;
        }
        if (object.equals(RawTransaction.COMMIT) || object.equals(RawTransaction.ABORT) || object.equals(this.identity)) {
            this.close();
            return;
        }
        if (object.equals(RawTransaction.SAVEPOINT_ROLLBACK)) {
            this.informObservers();
            return;
        }
        if (object.equals(RawTransaction.LOCK_ESCALATE)) {
            if (this.getLockingPolicy().getMode() != 1) {
                return;
            }
            try {
                this.getLockingPolicy().lockContainer(this.getTransaction(), this, false, this.forUpdate);
            }
            catch (StandardException standardException) {
                this.xact.setObserverException(standardException);
            }
        }
    }

    public PageActions getActionSet() {
        return this.actionsSet;
    }

    public AllocationActions getAllocationActionSet() {
        return this.allocActionsSet;
    }

    public boolean useContainer(boolean bl, boolean bl2) throws StandardException {
        boolean bl3 = this.getLockingPolicy().lockContainer(this.getTransaction(), this, bl2, this.forUpdate);
        if (!bl3) {
            this.container = null;
            throw StandardException.newException("40XL1");
        }
        if ((this.mode & 0x40) == 0) {
            if (!this.container.use(this, this.forUpdate, bl)) {
                this.getLockingPolicy().unlockContainer(this.xact, this);
                this.container = null;
                return false;
            }
            this.active = true;
        } else if (this.getLockingPolicy().getMode() != 1) {
            return true;
        }
        this.xact.addObserver(this);
        if ((this.mode & 0x408) == 0) {
            if ((this.mode & 0x10) == 16) {
                this.xact.addObserver(new TruncateOnCommit(this.identity, true));
            } else if ((this.mode & 0x100) == 256) {
                this.xact.addObserver(new TruncateOnCommit(this.identity, false));
            }
            if ((this.mode & 0x20) == 32) {
                this.xact.addObserver(new DropOnCommit(this.identity));
            }
            if ((this.mode & 0x200) == 512) {
                this.xact.addObserver(new SyncOnCommit(this.identity));
            }
        }
        return true;
    }

    public final RawTransaction getTransaction() {
        return this.xact;
    }

    public final LockingPolicy getLockingPolicy() {
        return this.locking;
    }

    public final void setLockingPolicy(LockingPolicy lockingPolicy) {
        this.locking = lockingPolicy;
    }

    public final boolean updateOK() {
        return this.forUpdate;
    }

    public int getMode() {
        return this.mode;
    }

    public void preDirty(boolean bl) throws StandardException {
        this.checkUpdateOpen();
        this.container.preDirty(bl);
    }

    public boolean isTemporaryContainer() throws StandardException {
        this.checkOpen();
        return this.identity != null && this.identity.getSegmentId() == -1L;
    }

    protected void checkOpen() throws StandardException {
        if (!this.active) {
            throw StandardException.newException("40XD0");
        }
    }

    private void checkUpdateOpen() throws StandardException {
        if (!this.active) {
            throw StandardException.newException("40XD0");
        }
        if (!this.forUpdate) {
            throw StandardException.newException("40XD1");
        }
    }

    protected void informObservers() {
        if (this.countObservers() != 0) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public SpaceInfo getSpaceInfo() throws StandardException {
        return this.container.getSpaceInfo(this);
    }

    public void backupContainer(String string) throws StandardException {
        this.checkOpen();
        this.container.backupContainer(this, string);
    }

    public void encryptOrDecryptContainer(String string, boolean bl) throws StandardException {
        this.checkOpen();
        this.container.encryptOrDecryptContainer(this, string, bl);
    }

    public String toString() {
        return super.toString();
    }
}

