/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.ISaslServer;
import org.apache.storm.messaging.netty.KerberosSaslNettyServer;
import org.apache.storm.messaging.netty.KerberosSaslNettyServerState;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosSaslServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslServerHandler.class);
    private final ISaslServer server;
    private final Map<String, Object> topoConf;
    private final String jaasSection;
    private final List<String> authorizedUsers;

    public KerberosSaslServerHandler(ISaslServer server, Map<String, Object> topoConf, String jaasSection, List<String> authorizedUsers) throws IOException {
        this.server = server;
        this.topoConf = topoConf;
        this.jaasSection = jaasSection;
        this.authorizedUsers = authorizedUsers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg == null) {
            return;
        }
        Channel channel = ctx.channel();
        if (msg instanceof SaslMessageToken) {
            try {
                LOG.debug("Got SaslMessageToken!");
                KerberosSaslNettyServer saslNettyServer = (KerberosSaslNettyServer)channel.attr(KerberosSaslNettyServerState.KERBOROS_SASL_NETTY_SERVER).get();
                if (saslNettyServer == null) {
                    LOG.debug("No saslNettyServer for {}  yet; creating now, with topology token: ", (Object)channel);
                    try {
                        saslNettyServer = new KerberosSaslNettyServer(this.topoConf, this.jaasSection, this.authorizedUsers);
                        channel.attr(KerberosSaslNettyServerState.KERBOROS_SASL_NETTY_SERVER).set((Object)saslNettyServer);
                    }
                    catch (RuntimeException ioe) {
                        LOG.error("Error occurred while creating saslNettyServer on server {} for client {}", (Object)channel.localAddress(), (Object)channel.remoteAddress());
                        throw ioe;
                    }
                } else {
                    LOG.debug("Found existing saslNettyServer on server: {} for client {}", (Object)channel.localAddress(), (Object)channel.remoteAddress());
                }
                byte[] responseBytes = saslNettyServer.response(((SaslMessageToken)msg).getSaslToken());
                SaslMessageToken saslTokenMessageRequest = new SaslMessageToken(responseBytes);
                if (saslTokenMessageRequest.getSaslToken() == null) {
                    channel.writeAndFlush((Object)ControlMessage.SASL_COMPLETE_REQUEST, channel.voidPromise());
                } else {
                    channel.writeAndFlush((Object)saslTokenMessageRequest, channel.voidPromise());
                }
                if (!saslNettyServer.isComplete()) return;
                LOG.info("SASL authentication is complete for client with username: {}", (Object)saslNettyServer.getUserName());
                channel.writeAndFlush((Object)ControlMessage.SASL_COMPLETE_REQUEST, channel.voidPromise());
                LOG.debug("Removing SaslServerHandler from pipeline since SASL authentication is complete.");
                ctx.pipeline().remove((ChannelHandler)this);
                this.server.authenticated(channel);
                return;
            }
            catch (Exception ex) {
                LOG.error("Failed to handle SaslMessageToken: ", (Throwable)ex);
                throw ex;
            }
        } else {
            LOG.warn("Sending upstream an unexpected non-SASL message : {}", msg);
            ctx.fireChannelRead(msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }
}

