/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2;

import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.XWorkJUnit4TestCase;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.util.StrutsTestCaseHelper;
import org.apache.struts2.views.jsp.StrutsMockServletContext;
import org.junit.After;
import org.junit.Before;

import java.util.Map;

public class StrutsJUnit4InternalTestCase extends XWorkJUnit4TestCase {

    protected StrutsMockServletContext servletContext;
    protected Dispatcher dispatcher;

    @Override
    @Before
    public void setUp() throws Exception {
        initDispatcher();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        StrutsTestCaseHelper.tearDown(dispatcher);
    }

    protected void initDispatcher() {
        initDispatcher(null);
    }

    protected void initDispatcher(Map<String, String> params) {
        StrutsTestCaseHelper.tearDown();
        servletContext = new StrutsMockServletContext();
        dispatcher = StrutsTestCaseHelper.initDispatcher(servletContext, params);
        configurationManager = dispatcher.getConfigurationManager();
        configuration = configurationManager.getConfiguration();
        container = configuration.getContainer();
        actionProxyFactory = container.getInstance(ActionProxyFactory.class);
    }
}
